/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib.edit.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;

public class HyperImageView
extends AppCompatImageView {
    private boolean showBorder = false;
    private int borderColor = -7829368;
    private int borderWidth = 5;
    private String absolutePath;
    private Bitmap bitmap;
    private Paint paint;

    public HyperImageView(Context context) {
        this(context, null);
    }

    public HyperImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HyperImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initData();
    }

    private void initData() {
        this.paint = new Paint();
        this.paint.setColor(this.borderColor);
        this.paint.setStrokeWidth((float)this.borderWidth);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.showBorder) {
            Rect rec = canvas.getClipBounds();
            canvas.drawRect(rec, this.paint);
        }
    }
}

