/*
 * Decompiled with CFR 0.152.
 */
package com.ns.yc.yccustomtextlib;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.ns.yc.yccustomtextlib.HyperImageView;
import com.ns.yc.yccustomtextlib.R;
import com.squareup.picasso.Picasso;

public class HyperTextView
extends ScrollView {
    private static final int EDIT_PADDING = 10;
    private int viewTagIndex = 1;
    private LinearLayout allLayout;
    private LayoutInflater inflater;

    public HyperTextView(Context context) {
        this(context, null);
    }

    public HyperTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HyperTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.inflater = LayoutInflater.from((Context)context);
        this.allLayout = new LinearLayout(context);
        this.allLayout.setOrientation(1);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        this.allLayout.setPadding(50, 15, 50, 15);
        this.addView((View)this.allLayout, (ViewGroup.LayoutParams)layoutParams);
        LinearLayout.LayoutParams firstEditParam = new LinearLayout.LayoutParams(-1, -1);
        TextView firstText = this.createTextView("\u6ca1\u6709\u5185\u5bb9", this.dip2px(context, 10.0f));
        this.allLayout.addView((View)firstText, (ViewGroup.LayoutParams)firstEditParam);
    }

    public int dip2px(Context context, float dipValue) {
        float m = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * m + 0.5f);
    }

    public void clearAllLayout() {
        this.allLayout.removeAllViews();
    }

    public int getLastIndex() {
        int lastEditIndex = this.allLayout.getChildCount();
        return lastEditIndex;
    }

    public TextView createTextView(String hint, int paddingTop) {
        TextView textView = (TextView)this.inflater.inflate(R.layout.hyper_text_view, null);
        textView.setTag((Object)this.viewTagIndex++);
        textView.setPadding(0, paddingTop, 0, paddingTop);
        textView.setHint((CharSequence)hint);
        return textView;
    }

    private RelativeLayout createImageLayout() {
        RelativeLayout layout2 = (RelativeLayout)this.inflater.inflate(R.layout.edit_image_view, null);
        layout2.setTag((Object)this.viewTagIndex++);
        View closeView = layout2.findViewById(R.id.image_close);
        closeView.setVisibility(8);
        return layout2;
    }

    public void addTextViewAtIndex(int index, CharSequence editStr) {
        TextView textView = this.createTextView("", 10);
        textView.setText(editStr);
        this.allLayout.addView((View)textView, index);
    }

    public void addImageViewAtIndex(int index, String imagePath) {
        if (imagePath == null || imagePath.length() == 0) {
            return;
        }
        Bitmap bmp = BitmapFactory.decodeFile((String)imagePath);
        RelativeLayout imageLayout = this.createImageLayout();
        HyperImageView imageView = (HyperImageView)imageLayout.findViewById(R.id.edit_imageView);
        Picasso.with((Context)this.getContext()).load(imagePath).centerCrop().into((ImageView)imageView);
        imageView.setAbsolutePath(imagePath);
        int imageHeight = 500;
        if (bmp != null) {
            imageHeight = this.allLayout.getWidth() * bmp.getHeight() / bmp.getWidth();
            bmp.recycle();
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, imageHeight);
        lp.bottomMargin = 10;
        imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.allLayout.addView((View)imageLayout, index);
    }

    public Bitmap getScaledBitmap(String filePath, int width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int sampleSize = options.outWidth > width ? options.outWidth / width + 1 : 1;
        options.inJustDecodeBounds = false;
        options.inSampleSize = sampleSize;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }
}

