/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.gallery;

import android.support.annotation.FloatRange;
import android.view.View;
import com.yc.cn.ycbannerlib.gallery.GalleryLayoutManager;

public class GalleryScaleTransformer
implements GalleryLayoutManager.ItemTransformer {
    private float scaleDivisor = 0.2f;

    public GalleryScaleTransformer(@FloatRange(from=0.0, to=1.0) float scaleSize) {
        this.scaleDivisor = scaleSize;
    }

    @Override
    public void transformItem(GalleryLayoutManager layoutManager, View item, float fraction) {
        item.setPivotX((float)item.getWidth() / 2.0f);
        item.setPivotY((float)item.getHeight() / 2.0f);
        if (this.scaleDivisor == 0.0f) {
            item.setPadding(30, 0, 30, 0);
        } else {
            float scale = 1.0f - this.scaleDivisor * Math.abs(fraction);
            item.setScaleX(scale);
            item.setScaleY(scale);
        }
    }
}

