/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.gallery;

import android.content.Context;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.Interpolator;

public class GallerySmoothScroller
extends LinearSmoothScroller {
    private static final float MILLISECONDS_PER_INCH = 100.0f;

    GallerySmoothScroller(Context context) {
        super(context);
    }

    protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
        return 100.0f / (float)displayMetrics.densityDpi;
    }

    protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
        int dy;
        int dx = this.calculateDxToMakeCentral(targetView);
        int distance = (int)Math.sqrt(dx * dx + (dy = this.calculateDyToMakeCentral(targetView)) * dy);
        int time = this.calculateTimeForDeceleration(distance);
        if (time > 0) {
            action.update(-dx, -dy, time, (Interpolator)this.mDecelerateInterpolator);
        }
    }

    private int calculateDxToMakeCentral(View view) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || !layoutManager.canScrollHorizontally()) {
            return 0;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int left = layoutManager.getDecoratedLeft(view) - params.leftMargin;
        int right = layoutManager.getDecoratedRight(view) + params.rightMargin;
        int start = layoutManager.getPaddingLeft();
        int end = layoutManager.getWidth() - layoutManager.getPaddingRight();
        int childCenter = left + (int)((float)(right - left) / 2.0f);
        int containerCenter = (int)((float)(end - start) / 2.0f);
        return containerCenter - childCenter;
    }

    private int calculateDyToMakeCentral(View view) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager == null || !layoutManager.canScrollVertically()) {
            return 0;
        }
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int top = layoutManager.getDecoratedTop(view) - params.topMargin;
        int bottom = layoutManager.getDecoratedBottom(view) + params.bottomMargin;
        int start = layoutManager.getPaddingTop();
        int end = layoutManager.getHeight() - layoutManager.getPaddingBottom();
        int childCenter = top + (int)((float)(bottom - top) / 2.0f);
        int containerCenter = (int)((float)(end - start) / 2.0f);
        return containerCenter - childCenter;
    }
}

