/*
 * Decompiled with CFR 0.152.
 */
package com.yc.cn.ycbannerlib.first;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.yc.cn.ycbannerlib.R;
import com.yc.cn.ycbannerlib.first.adapter.LoopPagerAdapter;
import com.yc.cn.ycbannerlib.first.click.OnBannerClickListener;
import com.yc.cn.ycbannerlib.first.hintview.BaseHintView;
import com.yc.cn.ycbannerlib.first.hintview.ColorPointHintView;
import com.yc.cn.ycbannerlib.first.util.SizeUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Timer;
import java.util.TimerTask;

public class BannerView
extends RelativeLayout {
    private ViewPager mViewPager;
    private PagerAdapter mAdapter;
    private OnBannerClickListener mOnItemClickListener;
    private GestureDetector mGestureDetector;
    private long mRecentTouchTime;
    private int delay;
    private int gravity;
    private int color;
    private int alpha;
    private int paddingLeft;
    private int paddingTop;
    private int paddingRight;
    private int paddingBottom;
    private View mHintView;
    private Timer timer;
    private HintViewDelegate mHintViewDelegate = new HintViewDelegate(){

        @Override
        public void setCurrentPosition(int position, BaseHintView hintView) {
            if (hintView != null) {
                hintView.setCurrent(position);
            }
        }

        @Override
        public void initView(int length, int gravity, BaseHintView hintView) {
            if (hintView != null) {
                hintView.initView(length, gravity);
            }
        }
    };
    private TimeTaskHandler mHandler = new TimeTaskHandler(this);

    public BannerView(Context context) {
        this(context, null);
    }

    public BannerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    private void initView(AttributeSet attrs) {
        if (this.mViewPager != null) {
            this.removeView((View)this.mViewPager);
        }
        TypedArray type = this.getContext().obtainStyledAttributes(attrs, R.styleable.RollViewPager);
        this.gravity = type.getInteger(R.styleable.RollViewPager_hint_gravity, 1);
        this.delay = type.getInt(R.styleable.RollViewPager_play_delay, 0);
        this.color = type.getColor(R.styleable.RollViewPager_hint_color, -16777216);
        this.alpha = type.getInt(R.styleable.RollViewPager_hint_alpha, 0);
        this.paddingLeft = (int)type.getDimension(R.styleable.RollViewPager_hint_paddingLeft, 0.0f);
        this.paddingRight = (int)type.getDimension(R.styleable.RollViewPager_hint_paddingRight, 0.0f);
        this.paddingTop = (int)type.getDimension(R.styleable.RollViewPager_hint_paddingTop, 0.0f);
        this.paddingBottom = (int)type.getDimension(R.styleable.RollViewPager_hint_paddingBottom, (float)SizeUtil.dip2px(this.getContext(), 4.0f));
        this.mViewPager = new ViewPager(this.getContext());
        this.mViewPager.setId(R.id.banner_inner);
        this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.addView((View)this.mViewPager);
        type.recycle();
        this.initHint(new ColorPointHintView(this.getContext(), Color.parseColor((String)"#E3AC42"), Color.parseColor((String)"#88ffffff")));
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                if (BannerView.this.mOnItemClickListener != null) {
                    if (BannerView.this.mAdapter instanceof LoopPagerAdapter) {
                        BannerView.this.mOnItemClickListener.onItemClick(BannerView.this.mViewPager.getCurrentItem() % ((LoopPagerAdapter)BannerView.this.mAdapter).getRealCount());
                    } else {
                        BannerView.this.mOnItemClickListener.onItemClick(BannerView.this.mViewPager.getCurrentItem());
                    }
                }
                return super.onSingleTapUp(e);
            }
        });
    }

    private void startPlay() {
        if (this.delay <= 0 || this.mAdapter == null || this.mAdapter.getCount() <= 1) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new WeakTimerTask(this), this.delay, (long)this.delay);
    }

    private void stopPlay() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void setHintViewDelegate(HintViewDelegate delegate) {
        this.mHintViewDelegate = delegate;
    }

    private void initHint(BaseHintView hintview) {
        if (this.mHintView != null) {
            this.removeView(this.mHintView);
        }
        if (hintview == null) {
            return;
        }
        this.mHintView = (View)hintview;
        this.loadHintView();
    }

    private void loadHintView() {
        this.addView(this.mHintView);
        this.mHintView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        lp.addRule(12);
        this.mHintView.setLayoutParams((ViewGroup.LayoutParams)lp);
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(this.color);
        gd.setAlpha(this.alpha);
        this.mHintView.setBackgroundDrawable((Drawable)gd);
        this.mHintViewDelegate.initView(this.mAdapter == null ? 0 : this.mAdapter.getCount(), this.gravity, (BaseHintView)this.mHintView);
    }

    public void setAnimationDurtion(final int during) {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            Scroller mScroller = new Scroller(this.getContext(), new Interpolator(){

                public float getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }
            }){

                public void startScroll(int startX, int startY, int dx, int dy, int duration) {
                    duration = System.currentTimeMillis() - BannerView.this.mRecentTouchTime > (long)BannerView.this.delay ? during : (duration /= 2);
                    super.startScroll(startX, startY, dx, dy, duration);
                }

                public void startScroll(int startX, int startY, int dx, int dy) {
                    super.startScroll(startX, startY, dx, dy, during);
                }
            };
            mField.set(this.mViewPager, mScroller);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setPlayDelay(int delay) {
        this.delay = delay;
        this.startPlay();
    }

    public void pause() {
        this.stopPlay();
    }

    public void resume() {
        this.startPlay();
    }

    public boolean isPlaying() {
        return this.timer != null;
    }

    public void setOnBannerClickListener(OnBannerClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setHintPadding(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        this.mHintView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
    }

    public void setHintAlpha(int alpha) {
        this.alpha = alpha;
        this.initHint((BaseHintView)this.mHintView);
    }

    public void setHintView(BaseHintView hintview) {
        if (this.mHintView != null) {
            this.removeView(this.mHintView);
        }
        this.mHintView = (View)hintview;
        if (hintview != null) {
            this.initHint(hintview);
        }
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setAdapter(PagerAdapter adapter) {
        adapter.registerDataSetObserver((DataSetObserver)new JPagerObserver());
        this.mViewPager.setAdapter(adapter);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position >= 0) {
                    BannerView.this.mHintViewDelegate.setCurrentPosition(position, (BaseHintView)BannerView.this.mHintView);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mAdapter = adapter;
        this.dataSetChanged();
    }

    private void dataSetChanged() {
        if (this.mHintView != null) {
            this.mHintViewDelegate.initView(this.mAdapter.getCount(), this.gravity, (BaseHintView)this.mHintView);
            this.mHintViewDelegate.setCurrentPosition(this.mViewPager.getCurrentItem(), (BaseHintView)this.mHintView);
        }
        this.startPlay();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mRecentTouchTime = System.currentTimeMillis();
        this.mGestureDetector.onTouchEvent(ev);
        return super.dispatchTouchEvent(ev);
    }

    private class JPagerObserver
    extends DataSetObserver {
        private JPagerObserver() {
        }

        public void onChanged() {
            BannerView.this.dataSetChanged();
        }

        public void onInvalidated() {
            BannerView.this.dataSetChanged();
        }
    }

    private static class WeakTimerTask
    extends TimerTask {
        private WeakReference<BannerView> mRollPagerViewWeakReference;

        WeakTimerTask(BannerView mRollPagerView) {
            this.mRollPagerViewWeakReference = new WeakReference<BannerView>(mRollPagerView);
        }

        @Override
        public void run() {
            BannerView rollPagerView = (BannerView)((Object)this.mRollPagerViewWeakReference.get());
            if (rollPagerView != null) {
                if (rollPagerView.isShown() && System.currentTimeMillis() - rollPagerView.mRecentTouchTime > (long)rollPagerView.delay) {
                    rollPagerView.mHandler.sendEmptyMessage(0);
                }
            } else {
                this.cancel();
            }
        }
    }

    private static final class TimeTaskHandler
    extends Handler {
        private WeakReference<BannerView> mRollPagerViewWeakReference;

        TimeTaskHandler(BannerView rollPagerView) {
            this.mRollPagerViewWeakReference = new WeakReference<BannerView>(rollPagerView);
        }

        public void handleMessage(Message msg) {
            BannerView rollPagerView = (BannerView)((Object)this.mRollPagerViewWeakReference.get());
            int cur = rollPagerView.getViewPager().getCurrentItem() + 1;
            if (cur >= rollPagerView.mAdapter.getCount()) {
                cur = 0;
            }
            rollPagerView.getViewPager().setCurrentItem(cur);
            rollPagerView.mHintViewDelegate.setCurrentPosition(cur, (BaseHintView)rollPagerView.mHintView);
            if (rollPagerView.mAdapter.getCount() <= 1) {
                rollPagerView.stopPlay();
            }
        }
    }

    public static interface HintViewDelegate {
        public void setCurrentPosition(int var1, BaseHintView var2);

        public void initView(int var1, int var2, BaseHintView var3);
    }
}

