/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.entity.LinkageFirst;
import cn.qqtheme.framework.entity.LinkageSecond;
import cn.qqtheme.framework.entity.LinkageThird;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class LinkagePicker<Fst extends LinkageFirst<Snd>, Snd extends LinkageSecond<Trd>, Trd>
extends WheelPicker {
    protected Fst selectedFirstItem;
    protected Snd selectedSecondItem;
    protected Trd selectedThirdItem;
    protected String firstLabel = "";
    protected String secondLabel = "";
    protected String thirdLabel = "";
    protected int selectedFirstIndex = 0;
    protected int selectedSecondIndex = 0;
    protected int selectedThirdIndex = 0;
    protected Provider provider;
    protected float firstColumnWeight = 1.0f;
    protected float secondColumnWeight = 1.0f;
    protected float thirdColumnWeight = 1.0f;
    private OnPickListener onPickListener;
    private OnLinkageListener onLinkageListener;
    private OnWheelListener onWheelListener;
    private OnWheelLinkageListener onWheelLinkageListener;

    public LinkagePicker(Activity activity) {
        super(activity);
    }

    public LinkagePicker(Activity activity, DataProvider provider) {
        super(activity);
        this.provider = provider;
    }

    public LinkagePicker(Activity activity, Provider<Fst, Snd, Trd> provider) {
        super(activity);
        this.provider = provider;
    }

    @Deprecated
    public LinkagePicker(Activity activity, List<Fst> firstList, List<List<Snd>> secondList) {
        this(activity, firstList, secondList, null);
    }

    @Deprecated
    public LinkagePicker(Activity activity, List<Fst> f, List<List<Snd>> s, List<List<List<Trd>>> t) {
        super(activity);
        this.provider = new DefaultDataProvider<Fst, Snd, Trd>(f, s, t);
    }

    protected void setProvider(DataProvider provider) {
        this.provider = provider;
    }

    protected void setProvider(Provider<Fst, Snd, Trd> provider) {
        this.provider = provider;
    }

    public void setSelectedIndex(int firstIndex, int secondIndex) {
        this.setSelectedIndex(firstIndex, secondIndex, 0);
    }

    public void setSelectedIndex(int firstIndex, int secondIndex, int thirdIndex) {
        this.selectedFirstIndex = firstIndex;
        this.selectedSecondIndex = secondIndex;
        this.selectedThirdIndex = thirdIndex;
    }

    public void setSelectedItem(Fst fst, Snd snd) {
        this.setSelectedItem(fst, snd, null);
    }

    public void setSelectedItem(Fst fst, Snd snd, Trd trd) {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set data provider at first");
        }
        List fsts = this.provider.initFirstData();
        int i = 0;
        for (LinkageFirst f : fsts) {
            if (f.equals(fst)) {
                this.selectedFirstIndex = i;
                break;
            }
            if (f.getId().equals(fst.getId()) || f.getName().contains(fst.getName())) {
                this.selectedFirstIndex = i;
                break;
            }
            ++i;
        }
        LogUtils.verbose((String)("init select first: " + fst.getName() + ", index:" + this.selectedFirstIndex));
        List snds = this.provider.linkageSecondData(this.selectedFirstIndex);
        int j = 0;
        for (LinkageSecond s : snds) {
            if (s.equals(snd)) {
                this.selectedSecondIndex = j;
                break;
            }
            if (s.getId().equals(snd.getId()) || s.getName().contains(snd.getName())) {
                this.selectedSecondIndex = j;
                break;
            }
            ++j;
        }
        LogUtils.verbose((String)("init select second: " + snd.getName() + ", index:" + this.selectedSecondIndex));
        if (this.provider.isOnlyTwo()) {
            return;
        }
        List trds = this.provider.linkageThirdData(this.selectedFirstIndex, this.selectedSecondIndex);
        int k = 0;
        for (Object t : trds) {
            if (t.equals(trd)) {
                this.selectedThirdIndex = k;
                break;
            }
            if (t instanceof LinkageThird) {
                LinkageThird ltrd = (LinkageThird)trd;
                LinkageThird lt = (LinkageThird)t;
                if (lt.getId().equals(ltrd.getId()) || lt.getName().contains(ltrd.getName())) {
                    this.selectedThirdIndex = k;
                    break;
                }
            }
            ++k;
        }
        LogUtils.verbose((String)("init select third: " + trd + ", index:" + this.selectedThirdIndex));
    }

    public void setLabel(String firstLabel, String secondLabel) {
        this.setLabel(firstLabel, secondLabel, "");
    }

    public void setLabel(String firstLabel, String secondLabel, String thirdLabel) {
        this.firstLabel = firstLabel;
        this.secondLabel = secondLabel;
        this.thirdLabel = thirdLabel;
    }

    public Fst getSelectedFirstItem() {
        if (this.selectedFirstItem == null) {
            this.selectedFirstItem = (LinkageFirst)this.provider.initFirstData().get(this.selectedFirstIndex);
        }
        return this.selectedFirstItem;
    }

    public Snd getSelectedSecondItem() {
        if (this.selectedSecondItem == null) {
            this.selectedSecondItem = (LinkageSecond)this.provider.linkageSecondData(this.selectedFirstIndex).get(this.selectedSecondIndex);
        }
        return this.selectedSecondItem;
    }

    public Trd getSelectedThirdItem() {
        List thirdData;
        if (this.selectedThirdItem == null && (thirdData = this.provider.linkageThirdData(this.selectedFirstIndex, this.selectedSecondIndex)).size() > 0) {
            this.selectedThirdItem = thirdData.get(this.selectedThirdIndex);
        }
        return this.selectedThirdItem;
    }

    public int getSelectedFirstIndex() {
        return this.selectedFirstIndex;
    }

    public int getSelectedSecondIndex() {
        return this.selectedSecondIndex;
    }

    public int getSelectedThirdIndex() {
        return this.selectedThirdIndex;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) float firstColumnWeight, @FloatRange(from=0.0, to=1.0) float secondColumnWeight, @FloatRange(from=0.0, to=1.0) float thirdColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = thirdColumnWeight;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) float firstColumnWeight, @FloatRange(from=0.0, to=1.0) float secondColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = 0.0f;
    }

    public void setOnWheelLinkageListener(OnWheelLinkageListener onWheelLinkageListener) {
        this.onWheelLinkageListener = onWheelLinkageListener;
    }

    @Deprecated
    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnPickListener(OnPickListener<Fst, Snd, Trd> onPickListener) {
        this.onPickListener = onPickListener;
    }

    public void setOnStringPickListener(OnStringPickListener onStringPickListener) {
        this.onPickListener = onStringPickListener;
    }

    @Deprecated
    public void setOnLinkageListener(OnLinkageListener onLinkageListener) {
        this.onLinkageListener = onLinkageListener;
    }

    @NonNull
    protected View makeCenterView() {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set data provider before make view");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView firstView = this.createWheelView();
        firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, this.firstColumnWeight));
        layout.addView((View)firstView);
        if (!TextUtils.isEmpty((CharSequence)this.firstLabel)) {
            TextView labelView = this.createLabelView();
            labelView.setText((CharSequence)this.firstLabel);
            layout.addView((View)labelView);
        }
        final WheelView secondView = this.createWheelView();
        secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, this.secondColumnWeight));
        layout.addView((View)secondView);
        if (!TextUtils.isEmpty((CharSequence)this.secondLabel)) {
            TextView labelView = this.createLabelView();
            labelView.setText((CharSequence)this.secondLabel);
            layout.addView((View)labelView);
        }
        final WheelView thirdView = this.createWheelView();
        if (!this.provider.isOnlyTwo()) {
            thirdView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, this.thirdColumnWeight));
            layout.addView((View)thirdView);
            if (!TextUtils.isEmpty((CharSequence)this.thirdLabel)) {
                TextView labelView = this.createLabelView();
                labelView.setText((CharSequence)this.thirdLabel);
                layout.addView((View)labelView);
            }
        }
        firstView.setItems(this.provider.initFirstData(), this.selectedFirstIndex);
        firstView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                LinkagePicker.this.selectedFirstItem = (LinkageFirst)LinkagePicker.this.provider.initFirstData().get(index);
                LinkagePicker.this.selectedFirstIndex = index;
                LogUtils.verbose((Object)this, (String)"change second data after first wheeled");
                LinkagePicker.this.selectedSecondIndex = 0;
                LinkagePicker.this.selectedThirdIndex = 0;
                List snds = LinkagePicker.this.provider.linkageSecondData(LinkagePicker.this.selectedFirstIndex);
                LinkagePicker.this.selectedSecondItem = (LinkageSecond)snds.get(LinkagePicker.this.selectedSecondIndex);
                secondView.setItems(snds, LinkagePicker.this.selectedSecondIndex);
                if (!LinkagePicker.this.provider.isOnlyTwo()) {
                    List trds = LinkagePicker.this.provider.linkageThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                    LinkagePicker.this.selectedThirdItem = trds.get(LinkagePicker.this.selectedThirdIndex);
                    thirdView.setItems(trds, LinkagePicker.this.selectedThirdIndex);
                }
                if (LinkagePicker.this.onWheelLinkageListener != null) {
                    LinkagePicker.this.onWheelLinkageListener.onLinkage(LinkagePicker.this.selectedFirstIndex, 0, 0);
                }
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onFirstWheeled(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedFirstItem.getName());
                }
            }
        });
        secondView.setItems(this.provider.linkageSecondData(this.selectedFirstIndex), this.selectedSecondIndex);
        secondView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                LinkagePicker.this.selectedSecondItem = (LinkageSecond)LinkagePicker.this.provider.linkageSecondData(LinkagePicker.this.selectedFirstIndex).get(index);
                LinkagePicker.this.selectedSecondIndex = index;
                if (!LinkagePicker.this.provider.isOnlyTwo()) {
                    LogUtils.verbose((Object)this, (String)"change third data after second wheeled");
                    LinkagePicker.this.selectedThirdIndex = 0;
                    List trds = LinkagePicker.this.provider.linkageThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                    LinkagePicker.this.selectedThirdItem = trds.get(LinkagePicker.this.selectedThirdIndex);
                    thirdView.setItems(trds, LinkagePicker.this.selectedThirdIndex);
                }
                if (LinkagePicker.this.onWheelLinkageListener != null) {
                    LinkagePicker.this.onWheelLinkageListener.onLinkage(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex, 0);
                }
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onSecondWheeled(LinkagePicker.this.selectedSecondIndex, LinkagePicker.this.selectedSecondItem.getName());
                }
            }
        });
        if (this.provider.isOnlyTwo()) {
            return layout;
        }
        thirdView.setItems(this.provider.linkageThirdData(this.selectedFirstIndex, this.selectedSecondIndex), this.selectedThirdIndex);
        thirdView.setOnItemSelectListener(new WheelView.OnItemSelectListener(){

            @Override
            public void onSelected(int index) {
                LinkagePicker.this.selectedThirdItem = LinkagePicker.this.provider.linkageThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex).get(index);
                LinkagePicker.this.selectedThirdIndex = index;
                if (LinkagePicker.this.onWheelLinkageListener != null) {
                    LinkagePicker.this.onWheelLinkageListener.onLinkage(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex, LinkagePicker.this.selectedThirdIndex);
                }
                if (LinkagePicker.this.onWheelListener != null) {
                    String thirdName = LinkagePicker.this.selectedThirdItem instanceof LinkageThird ? ((LinkageThird)LinkagePicker.this.selectedThirdItem).getName() : LinkagePicker.this.selectedThirdItem.toString();
                    LinkagePicker.this.onWheelListener.onThirdWheeled(LinkagePicker.this.selectedThirdIndex, thirdName);
                }
            }
        });
        return layout;
    }

    public void onSubmit() {
        Fst fst = this.getSelectedFirstItem();
        Snd snd = this.getSelectedSecondItem();
        Trd trd = this.getSelectedThirdItem();
        if (this.provider.isOnlyTwo()) {
            if (this.onPickListener != null) {
                this.onPickListener.onPicked(fst, snd, null);
            }
            if (this.onLinkageListener != null) {
                this.onLinkageListener.onPicked(fst.getName(), snd.getName(), null);
            }
        } else {
            if (this.onPickListener != null) {
                this.onPickListener.onPicked(fst, snd, trd);
            }
            if (this.onLinkageListener != null) {
                String thirdName = trd instanceof LinkageThird ? ((LinkageThird)trd).getName() : trd.toString();
                this.onLinkageListener.onPicked(fst.getName(), snd.getName(), thirdName);
            }
        }
    }

    private static class DefaultDataProvider<Fst extends LinkageFirst<Snd>, Snd extends LinkageSecond<Trd>, Trd>
    implements Provider<Fst, Snd, Trd> {
        private List<Fst> firstList = new ArrayList<Fst>();
        private List<List<Snd>> secondList = new ArrayList<List<Snd>>();
        private List<List<List<Trd>>> thirdList = new ArrayList<List<List<Trd>>>();
        private boolean onlyTwo = false;

        public DefaultDataProvider(List<Fst> f, List<List<Snd>> s, List<List<List<Trd>>> t) {
            this.firstList = f;
            this.secondList = s;
            if (t == null || t.size() == 0) {
                this.onlyTwo = true;
            } else {
                this.thirdList = t;
            }
        }

        @Override
        public boolean isOnlyTwo() {
            return this.onlyTwo;
        }

        @Override
        @NonNull
        public List<Fst> initFirstData() {
            return this.firstList;
        }

        @Override
        @NonNull
        public List<Snd> linkageSecondData(int firstIndex) {
            return this.secondList.get(firstIndex);
        }

        @Override
        @NonNull
        public List<Trd> linkageThirdData(int firstIndex, int secondIndex) {
            if (this.onlyTwo) {
                return new ArrayList();
            }
            return this.thirdList.get(firstIndex).get(secondIndex);
        }
    }

    public static abstract class DataProvider
    implements Provider<StringLinkageFirst, StringLinkageSecond, String> {
        @NonNull
        public abstract List<String> provideFirstData();

        @NonNull
        public abstract List<String> provideSecondData(int var1);

        @Nullable
        public abstract List<String> provideThirdData(int var1, int var2);

        @Override
        @NonNull
        public List<StringLinkageFirst> initFirstData() {
            ArrayList<StringLinkageFirst> firsts = new ArrayList<StringLinkageFirst>();
            List<String> data = this.provideFirstData();
            int i = 0;
            for (String str : data) {
                firsts.add(new StringLinkageFirst(str, this.linkageSecondData(i)));
                ++i;
            }
            return firsts;
        }

        @Override
        @NonNull
        public List<StringLinkageSecond> linkageSecondData(int firstIndex) {
            ArrayList<StringLinkageSecond> seconds = new ArrayList<StringLinkageSecond>();
            List<String> data = this.provideSecondData(firstIndex);
            int i = 0;
            for (String str : data) {
                seconds.add(new StringLinkageSecond(str, this.linkageThirdData(firstIndex, i)));
                ++i;
            }
            return seconds;
        }

        @Override
        @NonNull
        public List<String> linkageThirdData(int firstIndex, int secondIndex) {
            List<String> thirdData = this.provideThirdData(firstIndex, secondIndex);
            if (thirdData == null) {
                thirdData = new ArrayList<String>();
            }
            return thirdData;
        }
    }

    private static class StringLinkageSecond
    implements LinkageSecond<String> {
        private String name;
        private List<String> thirds = new ArrayList<String>();

        private StringLinkageSecond(String name, List<String> thirds) {
            this.name = name;
            this.thirds = thirds;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getId() {
            return this.name;
        }

        @Override
        public List<String> getThirds() {
            return this.thirds;
        }
    }

    private static class StringLinkageFirst
    implements LinkageFirst<StringLinkageSecond> {
        private String name;
        private List<StringLinkageSecond> seconds = new ArrayList<StringLinkageSecond>();

        private StringLinkageFirst(String name, List<StringLinkageSecond> seconds) {
            this.name = name;
            this.seconds = seconds;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getId() {
            return this.name;
        }

        @Override
        public List<StringLinkageSecond> getSeconds() {
            return this.seconds;
        }
    }

    public static interface Provider<Fst extends LinkageFirst<Snd>, Snd extends LinkageSecond<Trd>, Trd> {
        public boolean isOnlyTwo();

        @NonNull
        public List<Fst> initFirstData();

        @NonNull
        public List<Snd> linkageSecondData(int var1);

        @NonNull
        public List<Trd> linkageThirdData(int var1, int var2);
    }

    @Deprecated
    public static abstract class OnWheelListener {
        public abstract void onFirstWheeled(int var1, String var2);

        public abstract void onSecondWheeled(int var1, String var2);

        public void onThirdWheeled(int index, String item) {
        }
    }

    public static interface OnWheelLinkageListener {
        public void onLinkage(int var1, int var2, int var3);
    }

    @Deprecated
    public static abstract class OnLinkageListener
    extends OnStringPickListener {
    }

    public static abstract class OnStringPickListener
    implements OnPickListener<StringLinkageFirst, StringLinkageSecond, String> {
        @Override
        public abstract void onPicked(String var1, String var2, String var3);

        @Override
        public void onPicked(StringLinkageFirst first, StringLinkageSecond second, String third) {
            this.onPicked(first.getName(), second.getName(), third);
        }
    }

    public static interface OnPickListener<Fst, Snd, Trd> {
        public void onPicked(Fst var1, Snd var2, Trd var3);
    }
}

