/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.TextView;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.widget.WheelView;

public abstract class WheelPicker
extends ConfirmPopup<View> {
    protected static final int DURATION = 500;
    protected float lineSpaceMultiplier = 2.5f;
    protected int padding = -1;
    protected int textSize = 16;
    protected int textColorNormal = -4473925;
    protected int textColorFocus = -16611122;
    protected int offset = 3;
    protected boolean cycleDisable = true;
    protected WheelView.DividerConfig dividerConfig = new WheelView.DividerConfig();
    protected View contentView;

    public WheelPicker(Activity activity) {
        super(activity);
    }

    public final void setLineSpaceMultiplier(@FloatRange(from=2.0, to=4.0) float multiplier) {
        this.lineSpaceMultiplier = multiplier;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setTextColor(@ColorInt int textColorFocus, @ColorInt int textColorNormal) {
        this.textColorFocus = textColorFocus;
        this.textColorNormal = textColorNormal;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    public void setShadowVisible(boolean shadowVisible) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setShadowVisible(shadowVisible);
    }

    public void setShadowColor(@ColorInt int color) {
        this.setShadowColor(color, 100);
    }

    public void setShadowColor(@ColorInt int color, @IntRange(from=1L, to=255L) int alpha) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setShadowColor(color);
        this.dividerConfig.setShadowAlpha(alpha);
    }

    public void setDividerVisible(boolean visible) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setVisible(visible);
    }

    @Deprecated
    public void setLineVisible(boolean visible) {
        this.setDividerVisible(visible);
    }

    @Deprecated
    public void setLineColor(@ColorInt int color) {
        this.setDividerColor(color);
    }

    public void setDividerColor(@ColorInt int lineColor) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setVisible(true);
        this.dividerConfig.setColor(lineColor);
    }

    public void setDividerRatio(float ratio) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setRatio(ratio);
    }

    public void setDividerConfig(@Nullable WheelView.DividerConfig config) {
        if (null == config) {
            this.dividerConfig = new WheelView.DividerConfig();
            this.dividerConfig.setVisible(false);
            this.dividerConfig.setShadowVisible(false);
        } else {
            this.dividerConfig = config;
        }
    }

    @Deprecated
    public void setLineConfig(WheelView.DividerConfig config) {
        this.setDividerConfig(config);
    }

    public void setOffset(@IntRange(from=1L, to=5L) int offset) {
        this.offset = offset;
    }

    public void setCycleDisable(boolean cycleDisable) {
        this.cycleDisable = cycleDisable;
    }

    public View getContentView() {
        if (null == this.contentView) {
            this.contentView = this.makeCenterView();
        }
        return this.contentView;
    }

    protected WheelView createWheelView() {
        WheelView wheelView = new WheelView((Context)this.activity);
        wheelView.setLineSpaceMultiplier(this.lineSpaceMultiplier);
        wheelView.setPadding(this.padding);
        wheelView.setTextSize(this.textSize);
        wheelView.setTextColor(this.textColorNormal, this.textColorFocus);
        wheelView.setDividerConfig(this.dividerConfig);
        wheelView.setOffset(this.offset);
        wheelView.setCycleDisable(this.cycleDisable);
        return wheelView;
    }

    protected TextView createLabelView() {
        TextView labelView = new TextView((Context)this.activity);
        labelView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        labelView.setTextColor(this.textColorFocus);
        labelView.setTextSize((float)this.textSize);
        return labelView;
    }

    protected void showAfter() {
        super.showAfter();
        ViewGroup view = this.getRootView();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator translation = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{300.0f, 0.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{alpha, translation});
        animatorSet.setDuration(500L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.start();
    }

    public void dismiss() {
        ViewGroup view = this.getRootView();
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator translation = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{0.0f, 300.0f});
        animatorSet.playTogether(new Animator[]{alpha, translation});
        animatorSet.setDuration(500L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                WheelPicker.this.dismissImmediately();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
    }
}

