/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.support.annotation.NonNull;
import cn.qqtheme.framework.picker.LinkagePicker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CarNumberPicker
extends LinkagePicker {
    public CarNumberPicker(Activity activity) {
        super(activity, new CarNumberDataProvider());
    }

    @Override
    protected int[] getColumnWidths(boolean onlyTwoColumn) {
        return new int[]{-2, -2, 0};
    }

    public static class CarNumberDataProvider
    implements LinkagePicker.DataProvider {
        private List<String> provinces = Arrays.asList("\u4eac", "\u6d25", "\u5180", "\u664b", "\u8499", "\u8fbd", "\u5409", "\u9ed1", "\u6caa", "\u82cf", "\u6d59", "\u7696", "\u95fd", "\u8d63", "\u9c81", "\u8c6b", "\u9102", "\u6e58", "\u7ca4", "\u6842", "\u743c", "\u6e1d", "\u5ddd", "\u8d35", "\u4e91", "\u85cf", "\u9655", "\u7518", "\u9752", "\u5b81", "\u65b0");

        @Override
        public boolean isOnlyTwo() {
            return true;
        }

        @Override
        public List<String> provideFirstData() {
            return this.provinces;
        }

        @Override
        public List<String> provideSecondData(int firstIndex) {
            return this.parseData(this.provinces.get(firstIndex));
        }

        @Override
        public List<String> provideThirdData(int firstIndex, int secondIndex) {
            return new ArrayList<String>();
        }

        @NonNull
        private List<String> parseData(String province) {
            ArrayList<String> cities = new ArrayList<String>();
            switch (province) {
                case "\u4eac": {
                    for (char i = 'A'; i <= 'M'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.add("Y");
                    break;
                }
                case "\u6d25": {
                    for (char i = 'A'; i <= 'H'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    break;
                }
                case "\u5180": {
                    for (char i = 'A'; i <= 'H'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.add("J");
                    cities.add("R");
                    cities.add("S");
                    cities.add("T");
                    break;
                }
                case "\u664b": {
                    for (char i = 'A'; i <= 'M'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("G");
                    cities.remove("I");
                    break;
                }
                case "\u8499": {
                    for (char i = 'A'; i <= 'M'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u8fbd": {
                    for (char i = 'A'; i <= 'P'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u5409": {
                    for (char i = 'A'; i <= 'K'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u9ed1": {
                    for (char i = 'A'; i <= 'R'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u6caa": {
                    for (char i = 'A'; i <= 'D'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.add("R");
                    break;
                }
                case "\u82cf": {
                    for (char i = 'A'; i <= 'N'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u6d59": {
                    for (char i = 'A'; i <= 'L'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u7696": {
                    for (char i = 'A'; i <= 'S'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u95fd": {
                    for (char i = 'A'; i <= 'K'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u8d63": {
                    for (char i = 'A'; i <= 'M'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u9c81": {
                    for (char i = 'A'; i <= 'V'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    cities.remove("T");
                    cities.add("Y");
                    break;
                }
                case "\u8c6b": {
                    for (char i = 'A'; i <= 'U'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    cities.remove("T");
                    break;
                }
                case "\u9102": {
                    for (char i = 'A'; i <= 'S'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u6e58": {
                    for (char i = 'A'; i <= 'N'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    cities.add("U");
                    break;
                }
                case "\u7ca4": {
                    for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u6842": {
                    for (char i = 'A'; i <= 'P'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    cities.add("R");
                    break;
                }
                case "\u743c": 
                case "\u5b81": {
                    for (char i = 'A'; i <= 'E'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    break;
                }
                case "\u6e1d": {
                    for (char i = 'A'; i <= 'D'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("D");
                    cities.remove("E");
                    break;
                }
                case "\u5ddd": {
                    for (char i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("G");
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u8d35": 
                case "\u85cf": {
                    for (char i = 'A'; i <= 'J'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    break;
                }
                case "\u4e91": {
                    cities.add("A-V");
                    for (char i = 'A'; i <= 'S'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("B");
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u9655": {
                    for (char i = 'A'; i <= 'K'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.add("V");
                    break;
                }
                case "\u7518": {
                    for (char i = 'A'; i <= 'P'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                    break;
                }
                case "\u9752": {
                    for (char i = 'A'; i <= 'H'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    break;
                }
                case "\u65b0": {
                    for (char i = 'A'; i <= 'R'; i = (char)(i + '\u0001')) {
                        cities.add(String.valueOf(i));
                    }
                    cities.remove("I");
                    cities.remove("O");
                }
            }
            return cities;
        }
    }
}

