/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.entity.City;
import cn.qqtheme.framework.entity.County;
import cn.qqtheme.framework.entity.Province;
import cn.qqtheme.framework.picker.LinkagePicker;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class AddressPicker
extends LinkagePicker {
    private OnAddressPickListener onAddressPickListener;
    private OnWheelListener onWheelListener;
    private boolean hideProvince = false;
    private boolean hideCounty = false;
    private ArrayList<Province> provinces = new ArrayList();

    public AddressPicker(Activity activity, ArrayList<Province> provinces) {
        super(activity, new AddressProvider(provinces));
        this.provinces = provinces;
    }

    @Override
    public void setSelectedItem(String province, String city, String county) {
        super.setSelectedItem(province, city, county);
    }

    public Province getSelectedProvince() {
        return this.provinces.get(this.selectedFirstIndex);
    }

    public City getSelectedCity() {
        return this.getSelectedProvince().getCities().get(this.selectedSecondIndex);
    }

    public County getSelectedCounty() {
        return this.getSelectedCity().getCounties().get(this.selectedThirdIndex);
    }

    public void setHideProvince(boolean hideProvince) {
        this.hideProvince = hideProvince;
    }

    public void setHideCounty(boolean hideCounty) {
        this.hideCounty = hideCounty;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnAddressPickListener(OnAddressPickListener listener) {
        this.onAddressPickListener = listener;
    }

    @Override
    @Deprecated
    public final void setOnLinkageListener(LinkagePicker.OnLinkageListener onLinkageListener) {
        throw new UnsupportedOperationException("Please use setOnAddressPickListener instead.");
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set address provider before make view");
        }
        if (this.hideCounty) {
            this.hideProvince = false;
        }
        int[] widths = this.getColumnWidths(this.hideProvince || this.hideCounty);
        int provinceWidth = widths[0];
        int cityWidth = widths[1];
        int countyWidth = widths[2];
        if (this.hideProvince) {
            provinceWidth = 0;
            cityWidth = widths[0];
            countyWidth = widths[1];
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView provinceView = new WheelView((Context)this.activity);
        provinceView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(provinceWidth, -2));
        provinceView.setTextSize(this.textSize);
        provinceView.setTextColor(this.textColorNormal, this.textColorFocus);
        provinceView.setLineConfig(this.lineConfig);
        provinceView.setOffset(this.offset);
        provinceView.setCycleDisable(this.cycleDisable);
        layout.addView((View)provinceView);
        if (this.hideProvince) {
            provinceView.setVisibility(8);
        }
        final WheelView cityView = new WheelView((Context)this.activity);
        cityView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(cityWidth, -2));
        cityView.setTextSize(this.textSize);
        cityView.setTextColor(this.textColorNormal, this.textColorFocus);
        cityView.setLineConfig(this.lineConfig);
        cityView.setOffset(this.offset);
        cityView.setCycleDisable(this.cycleDisable);
        layout.addView((View)cityView);
        final WheelView countyView = new WheelView((Context)this.activity);
        countyView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(countyWidth, -2));
        countyView.setTextSize(this.textSize);
        countyView.setTextColor(this.textColorNormal, this.textColorFocus);
        countyView.setLineConfig(this.lineConfig);
        countyView.setOffset(this.offset);
        countyView.setCycleDisable(this.cycleDisable);
        layout.addView((View)countyView);
        if (this.hideCounty) {
            countyView.setVisibility(8);
        }
        provinceView.setItems(this.provider.provideFirstData(), this.selectedFirstIndex);
        provinceView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                AddressPicker.this.selectedFirstItem = item;
                AddressPicker.this.selectedFirstIndex = index;
                AddressPicker.this.selectedSecondIndex = 0;
                AddressPicker.this.selectedThirdIndex = 0;
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onProvinceWheeled(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedFirstItem);
                }
                LogUtils.verbose((Object)this, (String)"change cities after province wheeled");
                List<String> cities = AddressPicker.this.provider.provideSecondData(AddressPicker.this.selectedFirstIndex);
                if (cities.size() > 0) {
                    cityView.setItems(cities, AddressPicker.this.selectedSecondIndex);
                } else {
                    cityView.setItems(new ArrayList<String>());
                }
                List<String> counties = AddressPicker.this.provider.provideThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                if (counties.size() > 0) {
                    countyView.setItems(counties, AddressPicker.this.selectedThirdIndex);
                } else {
                    countyView.setItems(new ArrayList<String>());
                }
            }
        });
        cityView.setItems(this.provider.provideSecondData(this.selectedFirstIndex), this.selectedSecondIndex);
        cityView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                AddressPicker.this.selectedSecondItem = item;
                AddressPicker.this.selectedSecondIndex = index;
                AddressPicker.this.selectedThirdIndex = 0;
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onCityWheeled(AddressPicker.this.selectedSecondIndex, AddressPicker.this.selectedSecondItem);
                }
                LogUtils.verbose((Object)this, (String)"change counties after city wheeled");
                List<String> counties = AddressPicker.this.provider.provideThirdData(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedSecondIndex);
                if (counties.size() > 0) {
                    countyView.setItems(counties, AddressPicker.this.selectedThirdIndex);
                } else {
                    countyView.setItems(new ArrayList<String>());
                }
            }
        });
        countyView.setItems(this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex), this.selectedThirdIndex);
        countyView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                AddressPicker.this.selectedThirdItem = item;
                AddressPicker.this.selectedThirdIndex = index;
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onCountyWheeled(AddressPicker.this.selectedThirdIndex, AddressPicker.this.selectedThirdItem);
                }
            }
        });
        return layout;
    }

    @Override
    public void onSubmit() {
        if (this.onAddressPickListener != null) {
            Province province = this.getSelectedProvince();
            City city = this.getSelectedCity();
            County county = null;
            if (!this.hideCounty) {
                county = this.getSelectedCounty();
            }
            this.onAddressPickListener.onAddressPicked(province, city, county);
        }
    }

    public static class AddressProvider
    implements LinkagePicker.DataProvider {
        private List<String> firstList = new ArrayList<String>();
        private List<List<String>> secondList = new ArrayList<List<String>>();
        private List<List<List<String>>> thirdList = new ArrayList<List<List<String>>>();

        public AddressProvider(List<Province> provinces) {
            this.parseData(provinces);
        }

        @Override
        public boolean isOnlyTwo() {
            return this.thirdList.size() == 0;
        }

        @Override
        public List<String> provideFirstData() {
            return this.firstList;
        }

        @Override
        public List<String> provideSecondData(int firstIndex) {
            return this.secondList.get(firstIndex);
        }

        @Override
        public List<String> provideThirdData(int firstIndex, int secondIndex) {
            return this.thirdList.get(firstIndex).get(secondIndex);
        }

        private void parseData(List<Province> data) {
            int provinceSize = data.size();
            for (int x = 0; x < provinceSize; ++x) {
                Province pro = data.get(x);
                this.firstList.add(pro.getAreaName());
                List<City> cities = pro.getCities();
                ArrayList<String> xCities = new ArrayList<String>();
                ArrayList xCounties = new ArrayList();
                int citySize = cities.size();
                for (int y = 0; y < citySize; ++y) {
                    City cit = cities.get(y);
                    cit.setProvinceId(pro.getAreaId());
                    xCities.add(cit.getAreaName());
                    List<County> counties = cit.getCounties();
                    ArrayList<String> yCounties = new ArrayList<String>();
                    int countySize = counties.size();
                    if (countySize == 0) {
                        yCounties.add(cit.getAreaName());
                    } else {
                        for (int z = 0; z < countySize; ++z) {
                            County cou = counties.get(z);
                            cou.setCityId(cit.getAreaId());
                            yCounties.add(cou.getAreaName());
                        }
                    }
                    xCounties.add(yCounties);
                }
                this.secondList.add(xCities);
                this.thirdList.add(xCounties);
            }
        }
    }

    public static interface OnWheelListener {
        public void onProvinceWheeled(int var1, String var2);

        public void onCityWheeled(int var1, String var2);

        public void onCountyWheeled(int var1, String var2);
    }

    public static interface OnAddressPickListener {
        public void onAddressPicked(Province var1, City var2, County var3);
    }
}

