/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.widget.WheelView;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SinglePicker<T>
extends WheelPicker {
    private List<T> items = new ArrayList<T>();
    private List<String> itemStrings = new ArrayList<String>();
    private WheelView wheelView;
    private OnWheelListener onWheelListener;
    private OnItemPickListener<T> onItemPickListener;
    private int selectedItemIndex = 0;
    private String label = "";

    public SinglePicker(Activity activity, T[] items) {
        this(activity, Arrays.asList(items));
    }

    public SinglePicker(Activity activity, List<T> items) {
        super(activity);
        this.setItems(items);
    }

    public void addItem(T item) {
        this.items.add(item);
        this.itemStrings.add(this.formatToString(item));
    }

    public void removeItem(T item) {
        this.items.remove(item);
        this.itemStrings.remove(this.formatToString(item));
    }

    public void setItems(T[] items) {
        this.setItems(Arrays.asList(items));
    }

    public void setItems(List<T> items) {
        if (null == items || items.size() == 0) {
            return;
        }
        this.items = items;
        for (T item : items) {
            this.itemStrings.add(this.formatToString(item));
        }
        if (null != this.wheelView) {
            this.wheelView.setItems(this.itemStrings, this.selectedItemIndex);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.items.size()) {
            this.selectedItemIndex = index;
        }
    }

    public void setSelectedItem(@NonNull T item) {
        this.setSelectedIndex(this.itemStrings.indexOf(this.formatToString(item)));
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnItemPickListener(OnItemPickListener<T> listener) {
        this.onItemPickListener = listener;
    }

    @NonNull
    protected View makeCenterView() {
        if (this.items.size() == 0) {
            throw new IllegalArgumentException("please initial items at first, can't be empty");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.wheelView = new WheelView((Context)this.activity);
        this.wheelView.setTextSize(this.textSize);
        this.wheelView.setTextColor(this.textColorNormal, this.textColorFocus);
        this.wheelView.setLineConfig(this.lineConfig);
        this.wheelView.setOffset(this.offset);
        this.wheelView.setCycleDisable(this.cycleDisable);
        if (TextUtils.isEmpty((CharSequence)this.label)) {
            layout.addView((View)this.wheelView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        } else {
            layout.addView((View)this.wheelView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            TextView labelView = new TextView((Context)this.activity);
            labelView.setTextColor(this.textColorFocus);
            labelView.setTextSize((float)this.textSize);
            labelView.setText((CharSequence)this.label);
            layout.addView((View)labelView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        }
        this.wheelView.setItems(this.itemStrings, this.selectedItemIndex);
        this.wheelView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                SinglePicker.this.selectedItemIndex = index;
                if (SinglePicker.this.onWheelListener != null) {
                    SinglePicker.this.onWheelListener.onWheeled(SinglePicker.this.selectedItemIndex, item);
                }
            }
        });
        return layout;
    }

    private String formatToString(T item) {
        if (item instanceof Float || item instanceof Double) {
            return new DecimalFormat("0.00").format(item);
        }
        return item.toString();
    }

    public void onSubmit() {
        if (this.onItemPickListener != null) {
            this.onItemPickListener.onItemPicked(this.selectedItemIndex, this.getSelectedItem());
        }
    }

    public T getSelectedItem() {
        return this.items.get(this.selectedItemIndex);
    }

    public int getSelectedIndex() {
        return this.selectedItemIndex;
    }

    public static interface OnWheelListener {
        public void onWheeled(int var1, String var2);
    }

    public static interface OnItemPickListener<T> {
        public void onItemPicked(int var1, T var2);
    }
}

