/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class TimePicker
extends WheelPicker {
    public static final int HOUR_24 = 0;
    public static final int HOUR_12 = 1;
    private OnWheelListener onWheelListener;
    private OnTimePickListener onTimePickListener;
    private int mode;
    private String hourLabel = "\u65f6";
    private String minuteLabel = "\u5206";
    private String selectedHour = "";
    private String selectedMinute = "";
    private int startHour;
    private int startMinute = 0;
    private int endHour;
    private int endMinute = 59;

    public TimePicker(Activity activity) {
        this(activity, 0);
    }

    public TimePicker(Activity activity, int mode) {
        super(activity);
        this.mode = mode;
        if (mode == 1) {
            this.startHour = 1;
            this.endHour = 12;
            this.selectedHour = DateUtils.fillZero((int)Calendar.getInstance().get(10));
        } else {
            this.startHour = 0;
            this.endHour = 23;
            this.selectedHour = DateUtils.fillZero((int)Calendar.getInstance().get(11));
        }
        this.selectedMinute = DateUtils.fillZero((int)Calendar.getInstance().get(12));
    }

    public void setLabel(String hourLabel, String minuteLabel) {
        this.hourLabel = hourLabel;
        this.minuteLabel = minuteLabel;
    }

    public void setRangeStart(int startHour, int startMinute) {
        boolean illegal = false;
        if (startHour < 0 || startMinute < 0 || startMinute > 59) {
            illegal = true;
        }
        if (this.mode == 1 && (startHour == 0 || startHour > 12)) {
            illegal = true;
        }
        if (this.mode == 0 && startHour >= 24) {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("out of range");
        }
        this.startHour = startHour;
        this.startMinute = startMinute;
    }

    public void setRangeEnd(int endHour, int endMinute) {
        boolean illegal = false;
        if (endHour < 0 || endMinute < 0 || endMinute > 59) {
            illegal = true;
        }
        if (this.mode == 1 && (endHour == 0 || endHour > 12)) {
            illegal = true;
        }
        if (this.mode == 0 && endHour >= 24) {
            illegal = true;
        }
        if (illegal) {
            throw new IllegalArgumentException("out of range");
        }
        this.endHour = endHour;
        this.endMinute = endMinute;
    }

    public void setSelectedItem(int hour, int minute) {
        this.selectedHour = DateUtils.fillZero((int)hour);
        this.selectedMinute = DateUtils.fillZero((int)minute);
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnTimePickListener(OnTimePickListener listener) {
        this.onTimePickListener = listener;
    }

    @NonNull
    protected View makeCenterView() {
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView hourView = new WheelView((Context)this.activity);
        hourView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        hourView.setTextSize(this.textSize);
        hourView.setTextColor(this.textColorNormal, this.textColorFocus);
        hourView.setLineVisible(this.lineVisible);
        hourView.setLineColor(this.lineColor);
        layout.addView((View)hourView);
        TextView hourTextView = new TextView((Context)this.activity);
        hourTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        hourTextView.setTextSize((float)this.textSize);
        hourTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.hourLabel)) {
            hourTextView.setText((CharSequence)this.hourLabel);
        }
        layout.addView((View)hourTextView);
        final WheelView minuteView = new WheelView((Context)this.activity);
        minuteView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        minuteView.setTextSize(this.textSize);
        minuteView.setTextColor(this.textColorNormal, this.textColorFocus);
        minuteView.setLineVisible(this.lineVisible);
        minuteView.setLineColor(this.lineColor);
        minuteView.setOffset(this.offset);
        layout.addView((View)minuteView);
        TextView minuteTextView = new TextView((Context)this.activity);
        minuteTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        minuteTextView.setTextSize((float)this.textSize);
        minuteTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.minuteLabel)) {
            minuteTextView.setText((CharSequence)this.minuteLabel);
        }
        layout.addView((View)minuteTextView);
        ArrayList<String> hours = new ArrayList<String>();
        for (int i = this.startHour; i <= this.endHour; ++i) {
            hours.add(DateUtils.fillZero((int)i));
        }
        if (hours.indexOf(this.selectedHour) == -1) {
            this.selectedHour = (String)hours.get(0);
        }
        hourView.setItems(hours, this.selectedHour);
        minuteView.setItems(this.changeMinuteData(this.selectedHour), this.selectedMinute);
        hourView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                TimePicker.this.selectedHour = item;
                if (TimePicker.this.onWheelListener != null) {
                    TimePicker.this.onWheelListener.onHourWheeled(index, TimePicker.this.selectedHour);
                }
                minuteView.setItems((List<String>)TimePicker.this.changeMinuteData(item), TimePicker.this.selectedMinute);
            }
        });
        minuteView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                TimePicker.this.selectedMinute = item;
                if (TimePicker.this.onWheelListener != null) {
                    TimePicker.this.onWheelListener.onMinuteWheeled(index, TimePicker.this.selectedMinute);
                }
            }
        });
        return layout;
    }

    private ArrayList<String> changeMinuteData(String hour) {
        ArrayList<String> minutes = new ArrayList<String>();
        int hourInt = DateUtils.trimZero((String)hour);
        if (this.startHour == this.endHour) {
            if (this.startMinute > this.endMinute) {
                int temp = this.startMinute;
                this.startMinute = this.endMinute;
                this.endMinute = temp;
            }
            for (int i = this.startMinute; i <= this.endMinute; ++i) {
                minutes.add(DateUtils.fillZero((int)i));
            }
        } else if (hourInt == this.startHour) {
            for (int i = this.startMinute; i <= 59; ++i) {
                minutes.add(DateUtils.fillZero((int)i));
            }
        } else if (hourInt == this.endHour) {
            for (int i = 0; i <= this.endMinute; ++i) {
                minutes.add(DateUtils.fillZero((int)i));
            }
        } else {
            for (int i = 0; i <= 59; ++i) {
                minutes.add(DateUtils.fillZero((int)i));
            }
        }
        if (minutes.indexOf(this.selectedMinute) == -1) {
            this.selectedMinute = minutes.get(0);
        }
        return minutes;
    }

    public void onSubmit() {
        if (this.onTimePickListener != null) {
            this.onTimePickListener.onTimePicked(this.selectedHour, this.selectedMinute);
        }
    }

    public String getSelectedHour() {
        return this.selectedHour;
    }

    public String getSelectedMinute() {
        return this.selectedMinute;
    }

    public static interface OnWheelListener {
        public void onHourWheeled(int var1, String var2);

        public void onMinuteWheeled(int var1, String var2);
    }

    public static interface OnTimePickListener {
        public void onTimePicked(String var1, String var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

