/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LinkagePicker
extends WheelPicker {
    protected ArrayList<String> firstList = new ArrayList();
    protected ArrayList<ArrayList<String>> secondList = new ArrayList();
    protected ArrayList<ArrayList<ArrayList<String>>> thirdList = new ArrayList();
    protected OnLinkageListener onLinkageListener;
    protected String selectedFirstItem = "";
    protected String selectedSecondItem = "";
    protected String selectedThirdItem = "";
    protected int selectedFirstIndex = 0;
    protected int selectedSecondIndex = 0;
    protected int selectedThirdIndex = 0;
    protected boolean onlyTwo = false;
    private double firstColumnWeight = 0.0;
    private double secondColumnWeight = 0.0;
    private double thirdColumnWeight = 0.0;
    private OnWheelListener onWheelListener;

    public LinkagePicker(Activity activity) {
        super(activity);
    }

    public LinkagePicker(Activity activity, ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList) {
        this(activity, firstList, secondList, null);
    }

    public LinkagePicker(Activity activity, ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList, ArrayList<ArrayList<ArrayList<String>>> thirdList) {
        super(activity);
        this.firstList = firstList;
        this.secondList = secondList;
        if (thirdList == null || thirdList.size() == 0) {
            this.onlyTwo = true;
        } else {
            this.thirdList = thirdList;
        }
    }

    public void setSelectedItem(String firstText, String secondText) {
        this.setSelectedItem(firstText, secondText, "");
    }

    public void setSelectedItem(String firstText, String secondText, String thirdText) {
        for (int i = 0; i < this.firstList.size(); ++i) {
            String ft = this.firstList.get(i);
            if (!ft.contains(firstText)) continue;
            this.selectedFirstIndex = i;
            LogUtils.debug((String)("init select first text: " + ft + ", index:" + this.selectedFirstIndex));
            break;
        }
        ArrayList<String> secondTexts = this.secondList.get(this.selectedFirstIndex);
        for (int j = 0; j < secondTexts.size(); ++j) {
            String st = secondTexts.get(j);
            if (!st.contains(secondText)) continue;
            this.selectedSecondIndex = j;
            LogUtils.debug((String)("init select second text: " + st + ", index:" + this.selectedSecondIndex));
            break;
        }
        if (TextUtils.isEmpty((CharSequence)thirdText) || this.thirdList.size() == 0) {
            return;
        }
        ArrayList<String> thirdTexts = this.thirdList.get(this.selectedFirstIndex).get(this.selectedSecondIndex);
        for (int k = 0; k < thirdTexts.size(); ++k) {
            String tt = thirdTexts.get(k);
            if (!tt.contains(thirdText)) continue;
            this.selectedThirdIndex = k;
            LogUtils.debug((String)("init select third text: " + tt + ", index:" + this.selectedThirdIndex));
            break;
        }
    }

    public String getSelectedFirstItem() {
        return this.selectedFirstItem;
    }

    public String getSelectedSecondItem() {
        return this.selectedSecondItem;
    }

    public String getSelectedThirdItem() {
        return this.selectedThirdItem;
    }

    public int getSelectedFirstIndex() {
        return this.selectedFirstIndex;
    }

    public int getSelectedSecondIndex() {
        return this.selectedSecondIndex;
    }

    public int getSelectedThirdIndex() {
        return this.selectedThirdIndex;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) double firstColumnWeight, @FloatRange(from=0.0, to=1.0) double secondColumnWeight, @FloatRange(from=0.0, to=1.0) double thirdColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = thirdColumnWeight;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) double firstColumnWeight, @FloatRange(from=0.0, to=1.0) double secondColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = 0.0;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnLinkageListener(OnLinkageListener onLinkageListener) {
        this.onLinkageListener = onLinkageListener;
    }

    protected final int[] getColumnWidths(boolean onlyTwoColumn) {
        LogUtils.verbose((Object)((Object)this), (String)String.format(Locale.CHINA, "column weight is: %f-%f-%f", this.firstColumnWeight, this.secondColumnWeight, this.thirdColumnWeight));
        int[] widths = new int[3];
        if (this.firstColumnWeight == 0.0 && this.secondColumnWeight == 0.0 && this.thirdColumnWeight == 0.0) {
            if (onlyTwoColumn) {
                widths[0] = this.screenWidthPixels / 2;
                widths[1] = widths[0];
                widths[2] = 0;
            } else {
                widths[0] = this.screenWidthPixels / 3;
                widths[1] = widths[0];
                widths[2] = widths[0];
            }
        } else {
            widths[0] = (int)((double)this.screenWidthPixels * this.firstColumnWeight);
            widths[1] = (int)((double)this.screenWidthPixels * this.secondColumnWeight);
            widths[2] = (int)((double)this.screenWidthPixels * this.thirdColumnWeight);
        }
        return widths;
    }

    @NonNull
    protected View makeCenterView() {
        if (this.firstList.size() == 0 || this.secondList.size() == 0) {
            throw new IllegalArgumentException("please initial data at first, can't be empty");
        }
        int[] widths = this.getColumnWidths(this.onlyTwo);
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView firstView = new WheelView((Context)this.activity);
        firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(widths[0], -2));
        firstView.setTextSize(this.textSize);
        firstView.setTextColor(this.textColorNormal, this.textColorFocus);
        firstView.setLineVisible(this.lineVisible);
        firstView.setLineColor(this.lineColor);
        firstView.setOffset(this.offset);
        layout.addView((View)firstView);
        final WheelView secondView = new WheelView((Context)this.activity);
        secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(widths[1], -2));
        secondView.setTextSize(this.textSize);
        secondView.setTextColor(this.textColorNormal, this.textColorFocus);
        secondView.setLineVisible(this.lineVisible);
        secondView.setLineColor(this.lineColor);
        secondView.setOffset(this.offset);
        layout.addView((View)secondView);
        final WheelView thirdView = new WheelView((Context)this.activity);
        thirdView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(widths[2], -2));
        thirdView.setTextSize(this.textSize);
        thirdView.setTextColor(this.textColorNormal, this.textColorFocus);
        thirdView.setLineVisible(this.lineVisible);
        thirdView.setLineColor(this.lineColor);
        thirdView.setOffset(this.offset);
        layout.addView((View)thirdView);
        if (this.onlyTwo) {
            thirdView.setVisibility(8);
        }
        firstView.setItems(this.firstList, this.selectedFirstIndex);
        firstView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                ArrayList<String> secondData;
                LinkagePicker.this.selectedFirstItem = item;
                LinkagePicker.this.selectedFirstIndex = index;
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onFirstWheeled(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedFirstItem);
                }
                if ((secondData = LinkagePicker.this.secondList.get(LinkagePicker.this.selectedFirstIndex)).size() < LinkagePicker.this.selectedSecondIndex) {
                    LinkagePicker.this.selectedSecondIndex = 0;
                }
                LinkagePicker.this.selectedThirdIndex = 0;
                secondView.setItems(secondData, LinkagePicker.this.selectedSecondIndex);
                if (LinkagePicker.this.thirdList.size() == 0) {
                    return;
                }
                thirdView.setItems((List<String>)LinkagePicker.this.thirdList.get(LinkagePicker.this.selectedFirstIndex).get(LinkagePicker.this.selectedSecondIndex), LinkagePicker.this.selectedThirdIndex);
            }
        });
        secondView.setItems((List<String>)this.secondList.get(this.selectedFirstIndex), this.selectedSecondIndex);
        secondView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                LinkagePicker.this.selectedSecondItem = item;
                LinkagePicker.this.selectedSecondIndex = index;
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onSecondWheeled(LinkagePicker.this.selectedSecondIndex, LinkagePicker.this.selectedSecondItem);
                }
                if (LinkagePicker.this.thirdList.size() == 0) {
                    return;
                }
                ArrayList<String> thirdData = LinkagePicker.this.thirdList.get(LinkagePicker.this.selectedFirstIndex).get(LinkagePicker.this.selectedSecondIndex);
                if (thirdData.size() < LinkagePicker.this.selectedThirdIndex) {
                    LinkagePicker.this.selectedThirdIndex = 0;
                }
                thirdView.setItems(thirdData, LinkagePicker.this.selectedThirdIndex);
            }
        });
        if (this.thirdList.size() == 0) {
            return layout;
        }
        thirdView.setItems((List<String>)this.thirdList.get(this.selectedFirstIndex).get(this.selectedSecondIndex), this.selectedThirdIndex);
        thirdView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                LinkagePicker.this.selectedThirdItem = item;
                LinkagePicker.this.selectedThirdIndex = index;
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onThirdWheeled(LinkagePicker.this.selectedThirdIndex, LinkagePicker.this.selectedThirdItem);
                }
            }
        });
        return layout;
    }

    public void onSubmit() {
        if (this.onLinkageListener != null) {
            if (this.onlyTwo) {
                this.onLinkageListener.onPicked(this.selectedFirstItem, this.selectedSecondItem, null);
            } else {
                this.onLinkageListener.onPicked(this.selectedFirstItem, this.selectedSecondItem, this.selectedThirdItem);
            }
        }
    }

    public static interface OnWheelListener {
        public void onFirstWheeled(int var1, String var2);

        public void onSecondWheeled(int var1, String var2);

        public void onThirdWheeled(int var1, String var2);
    }

    public static interface OnLinkageListener {
        public void onPicked(String var1, String var2, String var3);
    }
}

