/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class LinkagePicker
extends WheelPicker {
    protected ArrayList<String> firstList = new ArrayList();
    protected ArrayList<ArrayList<String>> secondList = new ArrayList();
    protected ArrayList<ArrayList<ArrayList<String>>> thirdList = new ArrayList();
    protected OnLinkageListener onLinkageListener;
    protected String selectedFirstText = "";
    protected String selectedSecondText = "";
    protected String selectedThirdText = "";
    protected int selectedFirstIndex = 0;
    protected int selectedSecondIndex = 0;
    protected int selectedThirdIndex = 0;
    protected boolean onlyTwo = false;

    public LinkagePicker(Activity activity) {
        super(activity);
    }

    public LinkagePicker(Activity activity, ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList) {
        this(activity, firstList, secondList, null);
    }

    public LinkagePicker(Activity activity, ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList, ArrayList<ArrayList<ArrayList<String>>> thirdList) {
        super(activity);
        this.firstList = firstList;
        this.secondList = secondList;
        if (thirdList == null || thirdList.size() == 0) {
            this.onlyTwo = true;
        } else {
            this.thirdList = thirdList;
        }
    }

    public void setSelectedItem(String firstText, String secondText) {
        this.setSelectedItem(firstText, secondText, "");
    }

    public void setSelectedItem(String firstText, String secondText, String thirdText) {
        for (int i = 0; i < this.firstList.size(); ++i) {
            String ft = this.firstList.get(i);
            if (!ft.contains(firstText)) continue;
            this.selectedFirstIndex = i;
            LogUtils.debug((String)("init select first text: " + ft + ", index:" + this.selectedFirstIndex));
            break;
        }
        ArrayList<String> secondTexts = this.secondList.get(this.selectedFirstIndex);
        for (int j = 0; j < secondTexts.size(); ++j) {
            String st = secondTexts.get(j);
            if (!st.contains(secondText)) continue;
            this.selectedSecondIndex = j;
            LogUtils.debug((String)("init select second text: " + st + ", index:" + this.selectedSecondIndex));
            break;
        }
        if (TextUtils.isEmpty((CharSequence)thirdText) || this.thirdList.size() == 0) {
            return;
        }
        ArrayList<String> thirdTexts = this.thirdList.get(this.selectedFirstIndex).get(this.selectedSecondIndex);
        for (int k = 0; k < thirdTexts.size(); ++k) {
            String tt = thirdTexts.get(k);
            if (!tt.contains(thirdText)) continue;
            this.selectedThirdIndex = k;
            LogUtils.debug((String)("init select third text: " + tt + ", index:" + this.selectedThirdIndex));
            break;
        }
    }

    public void setOnLinkageListener(OnLinkageListener onLinkageListener) {
        this.onLinkageListener = onLinkageListener;
    }

    @NonNull
    protected View makeCenterView() {
        if (this.firstList.size() == 0 || this.secondList.size() == 0) {
            throw new IllegalArgumentException("please initial data at first, can't be empty");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView firstView = new WheelView((Context)this.activity);
        int width = this.screenWidthPixels / 3;
        firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, -2));
        firstView.setTextSize(this.textSize);
        firstView.setTextColor(this.textColorNormal, this.textColorFocus);
        firstView.setLineVisible(this.lineVisible);
        firstView.setLineColor(this.lineColor);
        firstView.setOffset(this.offset);
        layout.addView((View)firstView);
        final WheelView secondView = new WheelView((Context)this.activity);
        secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, -2));
        secondView.setTextSize(this.textSize);
        secondView.setTextColor(this.textColorNormal, this.textColorFocus);
        secondView.setLineVisible(this.lineVisible);
        secondView.setLineColor(this.lineColor);
        secondView.setOffset(this.offset);
        layout.addView((View)secondView);
        final WheelView thirdView = new WheelView((Context)this.activity);
        thirdView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, -2));
        thirdView.setTextSize(this.textSize);
        thirdView.setTextColor(this.textColorNormal, this.textColorFocus);
        thirdView.setLineVisible(this.lineVisible);
        thirdView.setLineColor(this.lineColor);
        thirdView.setOffset(this.offset);
        layout.addView((View)thirdView);
        if (this.onlyTwo) {
            thirdView.setVisibility(8);
        }
        firstView.setItems(this.firstList, this.selectedFirstIndex);
        firstView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                LinkagePicker.this.selectedFirstText = item;
                LinkagePicker.this.selectedFirstIndex = selectedIndex;
                LinkagePicker.this.selectedThirdIndex = 0;
                secondView.setItems((List<String>)LinkagePicker.this.secondList.get(LinkagePicker.this.selectedFirstIndex), isUserScroll ? 0 : LinkagePicker.this.selectedSecondIndex);
                if (LinkagePicker.this.thirdList.size() == 0) {
                    return;
                }
                thirdView.setItems((List<String>)LinkagePicker.this.thirdList.get(LinkagePicker.this.selectedFirstIndex).get(0), isUserScroll ? 0 : LinkagePicker.this.selectedThirdIndex);
            }
        });
        secondView.setItems((List<String>)this.secondList.get(this.selectedFirstIndex), this.selectedSecondIndex);
        secondView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                LinkagePicker.this.selectedSecondText = item;
                LinkagePicker.this.selectedSecondIndex = selectedIndex;
                if (LinkagePicker.this.thirdList.size() == 0) {
                    return;
                }
                thirdView.setItems((List<String>)LinkagePicker.this.thirdList.get(LinkagePicker.this.selectedFirstIndex).get(LinkagePicker.this.selectedSecondIndex), isUserScroll ? 0 : LinkagePicker.this.selectedThirdIndex);
            }
        });
        if (this.thirdList.size() == 0) {
            return layout;
        }
        thirdView.setItems((List<String>)this.thirdList.get(this.selectedFirstIndex).get(this.selectedSecondIndex), this.selectedThirdIndex);
        thirdView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                LinkagePicker.this.selectedThirdText = item;
                LinkagePicker.this.selectedThirdIndex = selectedIndex;
            }
        });
        return layout;
    }

    public void onSubmit() {
        if (this.onLinkageListener != null) {
            if (this.onlyTwo) {
                this.onLinkageListener.onPicked(this.selectedFirstText, this.selectedSecondText, null);
            } else {
                this.onLinkageListener.onPicked(this.selectedFirstText, this.selectedSecondText, this.selectedThirdText);
            }
        }
    }

    public static interface OnLinkageListener {
        public void onPicked(String var1, String var2, String var3);
    }
}

