/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.Arrays;

public class OptionPicker
extends WheelPicker {
    protected ArrayList<String> options = new ArrayList();
    private OnOptionPickListener onOptionPickListener;
    private String selectedOption = "";
    private String label = "";

    public OptionPicker(Activity activity, String[] options) {
        super(activity);
        this.options.addAll(Arrays.asList(options));
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSelectedIndex(int index) {
        for (int i = 0; i < this.options.size(); ++i) {
            if (index != i) continue;
            this.selectedOption = this.options.get(index);
            break;
        }
    }

    public void setSelectedItem(String option) {
        this.selectedOption = option;
    }

    public void setOnOptionPickListener(OnOptionPickListener listener) {
        this.onOptionPickListener = listener;
    }

    @Override
    protected View initContentView() {
        if (this.options.size() == 0) {
            throw new IllegalArgumentException("please initial options at first, can't be empty");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView optionView = new WheelView((Context)this.activity);
        optionView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        optionView.setTextSize(this.textSize);
        optionView.setTextColor(this.textColorNormal, this.textColorFocus);
        optionView.setLineVisible(this.lineVisible);
        optionView.setLineColor(this.lineColor);
        optionView.setOffset(this.offset);
        layout.addView((View)optionView);
        TextView labelView = new TextView((Context)this.activity);
        labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        labelView.setTextColor(this.textColorFocus);
        labelView.setTextSize((float)this.textSize);
        layout.addView((View)labelView);
        if (!TextUtils.isEmpty((CharSequence)this.label)) {
            labelView.setText((CharSequence)this.label);
        }
        if (TextUtils.isEmpty((CharSequence)this.selectedOption)) {
            optionView.setItems(this.options);
        } else {
            optionView.setItems(this.options, this.selectedOption);
        }
        optionView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                OptionPicker.this.selectedOption = item;
            }
        });
        return layout;
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        super.setContentViewAfter(contentView);
        super.setOnConfirmListener(new ConfirmPopup.OnConfirmListener(){

            @Override
            public void onConfirm() {
                if (OptionPicker.this.onOptionPickListener != null) {
                    OptionPicker.this.onOptionPickListener.onOptionPicked(OptionPicker.this.selectedOption);
                }
            }
        });
    }

    public static interface OnOptionPickListener {
        public void onOptionPicked(String var1);
    }
}

