/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DatePicker
extends WheelPicker {
    private ArrayList<String> years = new ArrayList();
    private ArrayList<String> months = new ArrayList();
    private ArrayList<String> days = new ArrayList();
    private OnDatePickListener onDatePickListener;
    private String yearLabel = "\u5e74";
    private String monthLabel = "\u6708";
    private String dayLabel = "\u65e5";
    private int selectedYearIndex = 0;
    private int selectedMonthIndex = 0;
    private int selectedDayIndex = 0;
    private Mode mode = Mode.YEAR_MONTH_DAY;

    public DatePicker(Activity activity) {
        this(activity, Mode.YEAR_MONTH_DAY);
    }

    public DatePicker(Activity activity, Mode mode) {
        super(activity);
        int i;
        this.mode = mode;
        for (i = 2000; i <= 2050; ++i) {
            this.years.add(String.valueOf(i));
        }
        for (i = 1; i <= 12; ++i) {
            this.months.add(DateUtils.fillZero(i));
        }
        for (i = 1; i <= 31; ++i) {
            this.days.add(DateUtils.fillZero(i));
        }
    }

    public void setLabel(String yearLabel, String monthLabel, String dayLabel) {
        this.yearLabel = yearLabel;
        this.monthLabel = monthLabel;
        this.dayLabel = dayLabel;
    }

    public void setRange(int startYear, int endYear) {
        this.years.clear();
        for (int i = startYear; i <= endYear; ++i) {
            this.years.add(String.valueOf(i));
        }
    }

    private int findItemIndex(ArrayList<String> items, int item) {
        int index = Collections.binarySearch(items, item, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                String lhsStr = lhs.toString();
                String rhsStr = rhs.toString();
                lhsStr = lhsStr.startsWith("0") ? lhsStr.substring(1) : lhsStr;
                rhsStr = rhsStr.startsWith("0") ? rhsStr.substring(1) : rhsStr;
                return Integer.parseInt(lhsStr) - Integer.parseInt(rhsStr);
            }
        });
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public void setSelectedItem(int year, int month, int day) {
        this.selectedYearIndex = this.findItemIndex(this.years, year);
        this.selectedMonthIndex = this.findItemIndex(this.months, month);
        this.selectedDayIndex = this.findItemIndex(this.days, day);
    }

    public void setSelectedItem(int yearOrMonth, int monthOrDay) {
        if (this.mode.equals((Object)Mode.MONTH_DAY)) {
            this.selectedMonthIndex = this.findItemIndex(this.months, yearOrMonth);
            this.selectedDayIndex = this.findItemIndex(this.days, monthOrDay);
        } else {
            this.selectedYearIndex = this.findItemIndex(this.years, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, monthOrDay);
        }
    }

    public void setOnDatePickListener(OnDatePickListener listener) {
        this.onDatePickListener = listener;
    }

    @Override
    protected View initContentView() {
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView yearView = new WheelView((Context)this.activity);
        yearView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        yearView.setTextSize(this.textSize);
        yearView.setTextColor(this.textColorNormal, this.textColorFocus);
        yearView.setLineVisible(this.lineVisible);
        yearView.setLineColor(this.lineColor);
        yearView.setOffset(this.offset);
        layout.addView((View)yearView);
        TextView yearTextView = new TextView((Context)this.activity);
        yearTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        yearTextView.setTextSize((float)this.textSize);
        yearTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
            yearTextView.setText((CharSequence)this.yearLabel);
        }
        layout.addView((View)yearTextView);
        WheelView monthView = new WheelView((Context)this.activity);
        monthView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        monthView.setTextSize(this.textSize);
        monthView.setTextColor(this.textColorNormal, this.textColorFocus);
        monthView.setLineVisible(this.lineVisible);
        monthView.setLineColor(this.lineColor);
        monthView.setOffset(this.offset);
        layout.addView((View)monthView);
        TextView monthTextView = new TextView((Context)this.activity);
        monthTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        monthTextView.setTextSize((float)this.textSize);
        monthTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
            monthTextView.setText((CharSequence)this.monthLabel);
        }
        layout.addView((View)monthTextView);
        final WheelView dayView = new WheelView((Context)this.activity);
        dayView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        dayView.setTextSize(this.textSize);
        dayView.setTextColor(this.textColorNormal, this.textColorFocus);
        dayView.setLineVisible(this.lineVisible);
        dayView.setLineColor(this.lineColor);
        dayView.setOffset(this.offset);
        layout.addView((View)dayView);
        TextView dayTextView = new TextView((Context)this.activity);
        dayTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        dayTextView.setTextSize((float)this.textSize);
        dayTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
            dayTextView.setText((CharSequence)this.dayLabel);
        }
        layout.addView((View)dayTextView);
        if (this.mode.equals((Object)Mode.YEAR_MONTH)) {
            dayView.setVisibility(8);
            dayTextView.setVisibility(8);
        } else if (this.mode.equals((Object)Mode.MONTH_DAY)) {
            yearView.setVisibility(8);
            yearTextView.setVisibility(8);
        }
        if (!this.mode.equals((Object)Mode.MONTH_DAY)) {
            if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
                yearTextView.setText((CharSequence)this.yearLabel);
            }
            if (this.selectedYearIndex == 0) {
                yearView.setItems(this.years);
            } else {
                yearView.setItems(this.years, this.selectedYearIndex);
            }
            yearView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

                @Override
                public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                    DatePicker.this.selectedYearIndex = selectedIndex;
                    DatePicker.this.days.clear();
                    int maxDays = DateUtils.calculateDaysInMonth(DatePicker.this.stringToYearMonthDay(item), DatePicker.this.stringToYearMonthDay((String)DatePicker.this.months.get(DatePicker.this.selectedMonthIndex)));
                    for (int i = 1; i <= maxDays; ++i) {
                        DatePicker.this.days.add(DateUtils.fillZero(i));
                    }
                    if (DatePicker.this.selectedDayIndex >= maxDays) {
                        DatePicker.this.selectedDayIndex = DatePicker.this.days.size() - 1;
                    }
                    dayView.setItems((List<String>)DatePicker.this.days, DatePicker.this.selectedDayIndex);
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
            monthTextView.setText((CharSequence)this.monthLabel);
        }
        if (this.selectedMonthIndex == 0) {
            monthView.setItems(this.months);
        } else {
            monthView.setItems(this.months, this.selectedMonthIndex);
        }
        monthView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                DatePicker.this.selectedMonthIndex = selectedIndex;
                if (!DatePicker.this.mode.equals((Object)Mode.YEAR_MONTH)) {
                    DatePicker.this.days.clear();
                    int maxDays = DateUtils.calculateDaysInMonth(DatePicker.this.stringToYearMonthDay((String)DatePicker.this.years.get(DatePicker.this.selectedYearIndex)), DatePicker.this.stringToYearMonthDay(item));
                    for (int i = 1; i <= maxDays; ++i) {
                        DatePicker.this.days.add(DateUtils.fillZero(i));
                    }
                    if (DatePicker.this.selectedDayIndex >= maxDays) {
                        DatePicker.this.selectedDayIndex = DatePicker.this.days.size() - 1;
                    }
                    dayView.setItems((List<String>)DatePicker.this.days, DatePicker.this.selectedDayIndex);
                }
            }
        });
        if (!this.mode.equals((Object)Mode.YEAR_MONTH)) {
            if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
                dayTextView.setText((CharSequence)this.dayLabel);
            }
            if (this.selectedDayIndex == 0) {
                dayView.setItems(this.days);
            } else {
                dayView.setItems(this.days, this.selectedDayIndex);
            }
            dayView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

                @Override
                public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                    DatePicker.this.selectedDayIndex = selectedIndex;
                }
            });
        }
        return layout;
    }

    private int stringToYearMonthDay(String text) {
        if (text.startsWith("0")) {
            text = text.substring(1);
        }
        return Integer.parseInt(text);
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        super.setContentViewAfter(contentView);
        super.setOnConfirmListener(new ConfirmPopup.OnConfirmListener(){

            @Override
            public void onConfirm() {
                if (DatePicker.this.onDatePickListener != null) {
                    String year = (String)DatePicker.this.years.get(DatePicker.this.selectedYearIndex);
                    String month = (String)DatePicker.this.months.get(DatePicker.this.selectedMonthIndex);
                    String day = (String)DatePicker.this.days.get(DatePicker.this.selectedDayIndex);
                    switch (DatePicker.this.mode) {
                        case YEAR_MONTH: {
                            ((OnYearMonthPickListener)DatePicker.this.onDatePickListener).onDatePicked(year, month);
                            break;
                        }
                        case MONTH_DAY: {
                            ((OnMonthDayPickListener)DatePicker.this.onDatePickListener).onDatePicked(month, day);
                            break;
                        }
                        default: {
                            ((OnYearMonthDayPickListener)DatePicker.this.onDatePickListener).onDatePicked(year, month, day);
                        }
                    }
                }
            }
        });
    }

    public static interface OnMonthDayPickListener
    extends OnDatePickListener {
        public void onDatePicked(String var1, String var2);
    }

    public static interface OnYearMonthPickListener
    extends OnDatePickListener {
        public void onDatePicked(String var1, String var2);
    }

    public static interface OnYearMonthDayPickListener
    extends OnDatePickListener {
        public void onDatePicked(String var1, String var2, String var3);
    }

    protected static interface OnDatePickListener {
    }

    public static enum Mode {
        YEAR_MONTH_DAY,
        YEAR_MONTH,
        MONTH_DAY;

    }
}

