/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class AddressPicker
extends WheelPicker {
    private ArrayList<String> provinceList = new ArrayList();
    private ArrayList<ArrayList<String>> cityList = new ArrayList();
    private ArrayList<ArrayList<ArrayList<String>>> countyList = new ArrayList();
    private OnAddressPickListener onAddressPickListener;
    private String selectedProvince = "";
    private String selectedCity = "";
    private String selectedCounty = "";
    private int selectedProvinceIndex = 0;
    private int selectedCityIndex = 0;
    private int selectedCountyIndex = 0;
    private boolean hideProvince = false;

    public AddressPicker(Activity activity, ArrayList<Province> data) {
        super(activity);
        int provinceSize = data.size();
        for (int x = 0; x < provinceSize; ++x) {
            Province pro = data.get(x);
            this.provinceList.add(pro.getAreaName());
            ArrayList<City> cities = pro.getCities();
            ArrayList<String> xCities = new ArrayList<String>();
            ArrayList xCounties = new ArrayList();
            int citySize = cities.size();
            for (int y = 0; y < citySize; ++y) {
                City cit = cities.get(y);
                xCities.add(cit.getAreaName());
                ArrayList<County> counties = cit.getCounties();
                ArrayList<String> yCounties = new ArrayList<String>();
                int countySize = counties.size();
                if (countySize == 0) {
                    yCounties.add(cit.getAreaName());
                } else {
                    for (int z = 0; z < countySize; ++z) {
                        yCounties.add(counties.get(z).getAreaName());
                    }
                }
                xCounties.add(yCounties);
            }
            this.cityList.add(xCities);
            this.countyList.add(xCounties);
        }
    }

    public void setSelectedItem(String province, String city, String county) {
        for (int i = 0; i < this.provinceList.size(); ++i) {
            String pro = this.provinceList.get(i);
            if (!pro.contains(province)) continue;
            this.selectedProvinceIndex = i;
            LogUtils.debug("init select province: " + pro);
            break;
        }
        ArrayList<String> cities = this.cityList.get(this.selectedProvinceIndex);
        for (int j = 0; j < cities.size(); ++j) {
            String cit = cities.get(j);
            if (!cit.contains(city)) continue;
            this.selectedCityIndex = j;
            LogUtils.debug("init select city: " + cit);
            break;
        }
        ArrayList<String> counties = this.countyList.get(this.selectedProvinceIndex).get(this.selectedCityIndex);
        for (int k = 0; k < counties.size(); ++k) {
            String cou = counties.get(k);
            if (!cou.contains(county)) continue;
            this.selectedCountyIndex = k;
            LogUtils.debug("init select county: " + cou);
            break;
        }
        LogUtils.debug(String.format("init select index: %s-%s-%s", this.selectedProvinceIndex, this.selectedCityIndex, this.selectedCountyIndex));
    }

    public void setHideProvince(boolean hideProvince) {
        this.hideProvince = hideProvince;
    }

    public void setOnAddressPickListener(OnAddressPickListener listener) {
        this.onAddressPickListener = listener;
    }

    @Override
    protected View initContentView() {
        if (this.provinceList.size() == 0) {
            throw new IllegalArgumentException("please initial options at first, can't be empty");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        int screenWidth = this.screen.widthPixels;
        WheelView provinceView = new WheelView((Context)this.activity);
        provinceView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(screenWidth / 3, -2));
        provinceView.setTextSize(this.textSize);
        provinceView.setTextColor(this.textColorNormal, this.textColorFocus);
        provinceView.setLineVisible(this.lineVisible);
        provinceView.setLineColor(this.lineColor);
        provinceView.setOffset(this.offset);
        layout.addView((View)provinceView);
        if (this.hideProvince) {
            provinceView.setVisibility(8);
        }
        final WheelView cityView = new WheelView((Context)this.activity);
        cityView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(screenWidth / 3, -2));
        cityView.setTextSize(this.textSize);
        cityView.setTextColor(this.textColorNormal, this.textColorFocus);
        cityView.setLineVisible(this.lineVisible);
        cityView.setLineColor(this.lineColor);
        cityView.setOffset(this.offset);
        layout.addView((View)cityView);
        final WheelView countyView = new WheelView((Context)this.activity);
        countyView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(screenWidth / 3, -2));
        countyView.setTextSize(this.textSize);
        countyView.setTextColor(this.textColorNormal, this.textColorFocus);
        countyView.setLineVisible(this.lineVisible);
        countyView.setLineColor(this.lineColor);
        countyView.setOffset(this.offset);
        layout.addView((View)countyView);
        provinceView.setItems(this.provinceList, this.selectedProvinceIndex);
        provinceView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                AddressPicker.this.selectedProvince = item;
                AddressPicker.this.selectedProvinceIndex = selectedIndex;
                AddressPicker.this.selectedCountyIndex = 0;
                cityView.setItems((List<String>)((List)AddressPicker.this.cityList.get(AddressPicker.this.selectedProvinceIndex)), isUserScroll ? 0 : AddressPicker.this.selectedCityIndex);
                countyView.setItems((List<String>)((List)((ArrayList)AddressPicker.this.countyList.get(AddressPicker.this.selectedProvinceIndex)).get(0)), isUserScroll ? 0 : AddressPicker.this.selectedCountyIndex);
            }
        });
        cityView.setItems((List<String>)this.cityList.get(this.selectedProvinceIndex), this.selectedCityIndex);
        cityView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                AddressPicker.this.selectedCity = item;
                AddressPicker.this.selectedCityIndex = selectedIndex;
                countyView.setItems((List<String>)((List)((ArrayList)AddressPicker.this.countyList.get(AddressPicker.this.selectedProvinceIndex)).get(AddressPicker.this.selectedCityIndex)), isUserScroll ? 0 : AddressPicker.this.selectedCountyIndex);
            }
        });
        countyView.setItems((List<String>)this.countyList.get(this.selectedProvinceIndex).get(this.selectedCityIndex), this.selectedCountyIndex);
        countyView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                AddressPicker.this.selectedCounty = item;
                AddressPicker.this.selectedCountyIndex = selectedIndex;
            }
        });
        return layout;
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        super.setContentViewAfter(contentView);
        super.setOnConfirmListener(new ConfirmPopup.OnConfirmListener(){

            @Override
            public void onConfirm() {
                if (AddressPicker.this.onAddressPickListener != null) {
                    AddressPicker.this.onAddressPickListener.onAddressPicked(AddressPicker.this.selectedProvince, AddressPicker.this.selectedCity, AddressPicker.this.selectedCounty);
                }
            }
        });
    }

    public static interface OnAddressPickListener {
        public void onAddressPicked(String var1, String var2, String var3);
    }

    public static class County
    extends Area {
    }

    public static class City
    extends Area {
        private ArrayList<County> counties = new ArrayList();

        public ArrayList<County> getCounties() {
            return this.counties;
        }

        public void setCounties(ArrayList<County> counties) {
            this.counties = counties;
        }
    }

    public static class Province
    extends Area {
        ArrayList<City> cities = new ArrayList();

        public ArrayList<City> getCities() {
            return this.cities;
        }

        public void setCities(ArrayList<City> cities) {
            this.cities = cities;
        }
    }

    public static abstract class Area {
        String areaId;
        String areaName;

        public String getAreaId() {
            return this.areaId;
        }

        public void setAreaId(String areaId) {
            this.areaId = areaId;
        }

        public String getAreaName() {
            return this.areaName;
        }

        public void setAreaName(String areaName) {
            this.areaName = areaName;
        }

        public String toString() {
            return "areaId=" + this.areaId + ",areaName=" + this.areaName;
        }
    }
}

