/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.Calendar;

public class TimePicker
extends WheelPicker {
    private OnTimePickListener onTimePickListener;
    private Mode mode;
    private String hourLabel = "\u65f6";
    private String minuteLabel = "\u5206";
    private String selectedHour = "";
    private String selectedMinute = "";

    public TimePicker(Activity activity) {
        this(activity, Mode.HOUR_OF_DAY);
    }

    public TimePicker(Activity activity, Mode mode) {
        super(activity);
        this.mode = mode;
        this.selectedHour = DateUtils.fillZero(Calendar.getInstance().get(11));
        this.selectedMinute = DateUtils.fillZero(Calendar.getInstance().get(12));
    }

    public void setLabel(String hourLabel, String minuteLabel) {
        this.hourLabel = hourLabel;
        this.minuteLabel = minuteLabel;
    }

    public void setSelectedItem(int hour, int minute) {
        this.selectedHour = String.valueOf(hour);
        this.selectedMinute = String.valueOf(minute);
    }

    public void setOnTimePickListener(OnTimePickListener listener) {
        this.onTimePickListener = listener;
    }

    @Override
    protected View initContentView() {
        int i;
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView hourView = new WheelView((Context)this.activity);
        hourView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        hourView.setTextSize(this.textSize);
        hourView.setTextColor(this.textColorNormal, this.textColorFocus);
        hourView.setLineVisible(this.lineVisible);
        hourView.setLineColor(this.lineColor);
        layout.addView((View)hourView);
        TextView hourTextView = new TextView((Context)this.activity);
        hourTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        hourTextView.setTextSize((float)this.textSize);
        hourTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.hourLabel)) {
            hourTextView.setText((CharSequence)this.hourLabel);
        }
        layout.addView((View)hourTextView);
        WheelView minuteView = new WheelView((Context)this.activity);
        minuteView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        minuteView.setTextSize(this.textSize);
        minuteView.setTextColor(this.textColorNormal, this.textColorFocus);
        minuteView.setLineVisible(this.lineVisible);
        minuteView.setLineColor(this.lineColor);
        minuteView.setOffset(this.offset);
        layout.addView((View)minuteView);
        TextView minuteTextView = new TextView((Context)this.activity);
        minuteTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        minuteTextView.setTextSize((float)this.textSize);
        minuteTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.minuteLabel)) {
            minuteTextView.setText((CharSequence)this.minuteLabel);
        }
        layout.addView((View)minuteTextView);
        ArrayList<String> hours = new ArrayList<String>();
        if (this.mode.equals((Object)Mode.HOUR)) {
            for (i = 1; i <= 12; ++i) {
                hours.add(DateUtils.fillZero(i));
            }
        } else {
            for (i = 0; i < 24; ++i) {
                hours.add(DateUtils.fillZero(i));
            }
        }
        hourView.setItems(hours, this.selectedHour);
        ArrayList<String> minutes = new ArrayList<String>();
        for (int i2 = 0; i2 < 60; ++i2) {
            minutes.add(DateUtils.fillZero(i2));
        }
        minuteView.setItems(minutes, this.selectedMinute);
        hourView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                TimePicker.this.selectedHour = item;
            }
        });
        minuteView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                TimePicker.this.selectedMinute = item;
            }
        });
        return layout;
    }

    @Override
    protected void setContentViewAfter(View contentView) {
        super.setContentViewAfter(contentView);
        super.setOnConfirmListener(new ConfirmPopup.OnConfirmListener(){

            @Override
            public void onConfirm() {
                if (TimePicker.this.onTimePickListener != null) {
                    TimePicker.this.onTimePickListener.onTimePicked(TimePicker.this.selectedHour, TimePicker.this.selectedMinute);
                }
            }
        });
    }

    public static interface OnTimePickListener {
        public void onTimePicked(String var1, String var2);
    }

    public static enum Mode {
        HOUR_OF_DAY,
        HOUR;

    }
}

