/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import cn.qqtheme.framework.adapter.FileAdapter;
import cn.qqtheme.framework.entity.FileItem;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.util.StorageUtils;
import cn.qqtheme.framework.widget.MarqueeTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class FilePicker
extends ConfirmPopup<LinearLayout>
implements AdapterView.OnItemClickListener {
    public static final int DIRECTORY = 0;
    public static final int FILE = 1;
    private String initPath;
    private FileAdapter adapter;
    private TextView emptyView;
    private MarqueeTextView textView;
    private OnFilePickListener onFilePickListener;
    private int mode;
    private CharSequence emptyHint;

    public FilePicker(Activity activity, int mode) {
        super(activity);
        this.setHalfScreen(true);
        try {
            this.initPath = StorageUtils.getDownloadPath();
        }
        catch (RuntimeException e) {
            this.initPath = StorageUtils.getInternalRootPath((Context)activity);
        }
        this.mode = mode;
        this.emptyHint = mode == 0 ? "\u6ca1\u6709\u6240\u9700\u76ee\u5f55" : "\u6ca1\u6709\u6240\u9700\u6587\u4ef6";
        this.adapter = new FileAdapter((Context)activity);
        this.adapter.setOnlyListDir(mode == 0);
        this.adapter.setShowHideDir(false);
        this.adapter.setShowHomeDir(false);
        this.adapter.setShowUpDir(true);
    }

    @NonNull
    protected LinearLayout makeCenterView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setOrientation(1);
        rootLayout.setBackgroundColor(-1);
        ListView listView = new ListView((Context)this.activity);
        listView.setBackgroundColor(-1);
        listView.setDivider((Drawable)new ColorDrawable(-2236963));
        listView.setDividerHeight(1);
        listView.setCacheColorHint(0);
        listView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        listView.setAdapter((ListAdapter)this.adapter);
        listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        rootLayout.addView((View)listView);
        this.emptyView = new TextView((Context)this.activity);
        LinearLayout.LayoutParams txtParams = new LinearLayout.LayoutParams(-1, -2);
        txtParams.gravity = 17;
        this.emptyView.setLayoutParams((ViewGroup.LayoutParams)txtParams);
        this.emptyView.setGravity(17);
        this.emptyView.setVisibility(8);
        this.emptyView.setTextColor(-16777216);
        rootLayout.addView((View)this.emptyView);
        return rootLayout;
    }

    @Nullable
    protected View makeFooterView() {
        this.textView = new MarqueeTextView((Context)this.activity);
        this.textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.textView.setTextColor(-16777216);
        this.textView.setGravity(16);
        int padding = ConvertUtils.toPx((Context)this.activity, (float)10.0f);
        this.textView.setPadding(padding, padding, padding, padding);
        return this.textView;
    }

    public void setRootPath(String initPath) {
        this.initPath = initPath;
    }

    public void setAllowExtensions(String[] allowExtensions) {
        this.adapter.setAllowExtensions(allowExtensions);
    }

    public void setShowUpDir(boolean showUpDir) {
        this.adapter.setShowUpDir(showUpDir);
    }

    public void setShowHomeDir(boolean showHomeDir) {
        this.adapter.setShowHomeDir(showHomeDir);
    }

    public void setShowHideDir(boolean showHideDir) {
        this.adapter.setShowHideDir(showHideDir);
    }

    public void setItemHeight(int itemHeight) {
        this.adapter.setItemHeight(itemHeight);
    }

    public void setEmptyHint(CharSequence emptyHint) {
        this.emptyHint = emptyHint;
    }

    protected void setContentViewBefore() {
        boolean isPickFile = this.mode == 1;
        this.setCancelVisible(!isPickFile);
        if (isPickFile) {
            this.setSubmitText(this.activity.getString(0x1040000));
        } else {
            this.setSubmitText(this.activity.getString(17039370));
        }
    }

    protected void setContentViewAfter(View contentView) {
        this.refreshCurrentDirPath(this.initPath);
    }

    protected void onSubmit() {
        if (this.mode == 1) {
            LogUtils.verbose((String)"pick file canceled");
        } else {
            String currentPath = this.adapter.getCurrentPath();
            LogUtils.debug((String)("picked directory: " + currentPath));
            if (this.onFilePickListener != null) {
                this.onFilePickListener.onFilePicked(currentPath);
            }
        }
    }

    public void dismiss() {
        super.dismiss();
        this.adapter.recycleData();
    }

    public FileAdapter getAdapter() {
        return this.adapter;
    }

    public String getCurrentPath() {
        return this.adapter.getCurrentPath();
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
        FileItem fileItem = this.adapter.getItem(position);
        if (fileItem.isDirectory()) {
            this.refreshCurrentDirPath(fileItem.getPath());
        } else {
            String clickPath = fileItem.getPath();
            if (this.mode == 0) {
                LogUtils.warn((String)("not directory: " + clickPath));
            } else {
                this.dismiss();
                LogUtils.debug((String)("picked path: " + clickPath));
                if (this.onFilePickListener != null) {
                    this.onFilePickListener.onFilePicked(clickPath);
                }
            }
        }
    }

    private void refreshCurrentDirPath(String currentPath) {
        if (currentPath.equals("/")) {
            this.textView.setText("  /  ");
        } else {
            this.textView.setText(currentPath);
        }
        this.adapter.loadData(currentPath);
        int adapterCount = this.adapter.getCount();
        if (adapterCount <= 1) {
            LogUtils.verbose((Object)((Object)this), (String)"no files, or dir is empty");
            this.emptyView.setVisibility(0);
            this.emptyView.setText(this.emptyHint);
        } else {
            LogUtils.verbose((Object)((Object)this), (String)("files or dirs count: " + adapterCount));
            this.emptyView.setVisibility(8);
        }
    }

    public void setOnFilePickListener(OnFilePickListener listener) {
        this.onFilePickListener = listener;
    }

    public static interface OnFilePickListener {
        public void onFilePicked(String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

