/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.popup;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import cn.qqtheme.framework.popup.BottomPopup;
import cn.qqtheme.framework.util.ConvertUtils;

public abstract class ConfirmPopup<V extends View>
extends BottomPopup<View>
implements View.OnClickListener {
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";
    private boolean topLineVisible = true;
    private int topLineColor = -2236963;
    private int topBackgroundColor = -1;
    private boolean cancelVisible = true;
    private CharSequence cancelText = "";
    private CharSequence submitText = "";
    private int cancelTextColor = -16777216;
    private int submitTextColor = -16777216;
    private OnConfirmListener onConfirmListener;

    public ConfirmPopup(Activity activity) {
        super(activity);
        this.cancelText = activity.getString(0x1040000);
        this.submitText = activity.getString(17039370);
    }

    protected abstract V initContentView();

    public void setTopLineColor(@ColorInt int topLineColor) {
        this.topLineColor = topLineColor;
    }

    public void setTopBackgroundColor(@ColorInt int topBackgroundColor) {
        this.topBackgroundColor = topBackgroundColor;
    }

    public void setTopLineVisible(boolean topLineVisible) {
        this.topLineVisible = topLineVisible;
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.cancelVisible = cancelVisible;
    }

    public void setCancelText(CharSequence cancelText) {
        this.cancelText = cancelText;
    }

    public void setSubmitText(CharSequence submitText) {
        this.submitText = submitText;
    }

    public void setCancelTextColor(@ColorInt int cancelTextColor) {
        this.cancelTextColor = cancelTextColor;
    }

    public void setSubmitTextColor(@ColorInt int submitTextColor) {
        this.submitTextColor = submitTextColor;
    }

    @Override
    protected View getView() {
        LinearLayout rootLayout = new LinearLayout((Context)this.activity);
        rootLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        rootLayout.setBackgroundColor(-1);
        rootLayout.setOrientation(1);
        rootLayout.setGravity(17);
        rootLayout.setPadding(0, 0, 0, 0);
        rootLayout.setClipToPadding(false);
        RelativeLayout topButtonLayout = new RelativeLayout((Context)this.activity);
        topButtonLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, ConvertUtils.toPx((Context)this.activity, 40.0f)));
        topButtonLayout.setBackgroundColor(this.topBackgroundColor);
        topButtonLayout.setGravity(16);
        Button cancelButton = new Button((Context)this.activity);
        cancelButton.setVisibility(this.cancelVisible ? 0 : 8);
        cancelButton.setTag((Object)TAG_CANCEL);
        RelativeLayout.LayoutParams cancelButtonLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        cancelButtonLayoutParams.addRule(9, -1);
        cancelButtonLayoutParams.addRule(15, -1);
        cancelButton.setLayoutParams((ViewGroup.LayoutParams)cancelButtonLayoutParams);
        cancelButton.setBackgroundColor(0);
        cancelButton.setGravity(17);
        if (!TextUtils.isEmpty((CharSequence)this.cancelText)) {
            cancelButton.setText(this.cancelText);
        }
        cancelButton.setTextColor(this.cancelTextColor);
        cancelButton.setOnClickListener((View.OnClickListener)this);
        topButtonLayout.addView((View)cancelButton);
        Button submitButton = new Button((Context)this.activity);
        submitButton.setTag((Object)TAG_SUBMIT);
        RelativeLayout.LayoutParams submitButtonLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        submitButtonLayoutParams.addRule(11, -1);
        submitButtonLayoutParams.addRule(15, -1);
        submitButton.setLayoutParams((ViewGroup.LayoutParams)submitButtonLayoutParams);
        submitButton.setBackgroundColor(0);
        submitButton.setGravity(17);
        if (!TextUtils.isEmpty((CharSequence)this.submitText)) {
            submitButton.setText(this.submitText);
        }
        submitButton.setTextColor(this.submitTextColor);
        submitButton.setOnClickListener((View.OnClickListener)this);
        topButtonLayout.addView((View)submitButton);
        rootLayout.addView((View)topButtonLayout);
        if (this.topLineVisible) {
            View lineView = new View((Context)this.activity);
            lineView.setLayoutParams(new ViewGroup.LayoutParams(-1, 1));
            lineView.setBackgroundColor(this.topLineColor);
            rootLayout.addView(lineView);
        }
        rootLayout.addView(this.initContentView());
        return rootLayout;
    }

    public void onClick(View v) {
        if (this.onConfirmListener != null) {
            String tag = v.getTag().toString();
            if (tag.equals(TAG_SUBMIT)) {
                this.onConfirmListener.onConfirm();
            } else {
                this.onConfirmListener.onCancel();
            }
        }
        this.dismiss();
    }

    protected void setOnConfirmListener(OnConfirmListener onConfirmListener) {
        this.onConfirmListener = onConfirmListener;
    }

    protected static abstract class OnConfirmListener {
        protected OnConfirmListener() {
        }

        public abstract void onConfirm();

        public void onCancel() {
        }
    }
}

