/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.utils;

import com.basic.util.ByteUtil;
import com.basic.util.TimeUtil;
import com.orhanobut.logger.Logger;
import java.util.Calendar;

public class HealthThermometerServiceUtil {
    private static final int HIDE_MSB_8BITS_OUT_OF_32BITS = 0xFFFFFF;
    private static final int HIDE_MSB_8BITS_OUT_OF_16BITS = 255;
    private static final int SHIFT_LEFT_8BITS = 8;
    private static final int SHIFT_LEFT_16BITS = 16;
    private static final int GET_BIT24 = 0x400000;
    private static final int FIRST_BIT_MASK = 1;
    private static final int SECOND_BIT_MASK = 2;
    private static final int THIRD_BIT_MASK = 4;

    public static boolean checkOver(byte[] data) {
        return HealthThermometerServiceUtil.checkSpecialValue(data, (byte)-1);
    }

    public static boolean checkMeasuring(byte[] data) {
        return HealthThermometerServiceUtil.checkSpecialValue(data, (byte)-18);
    }

    private static boolean checkSpecialValue(byte[] data, byte v) {
        boolean flag = true;
        if (data != null && data.length > 4) {
            for (int i = 1; i <= 3; ++i) {
                if (data[i] == v) continue;
                flag = false;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static int getTimestamp(byte[] data) {
        byte flag;
        if (data.length > 0 && ((flag = data[0]) & 2) != 0) {
            short year = ByteUtil.getShort((byte[])new byte[]{data[5], data[6]});
            byte month = data[7];
            byte day = data[8];
            byte hour = data[9];
            byte min = data[10];
            byte sec = data[11];
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month - 1, day, hour, min, sec);
            return TimeUtil.getTimestamp((long)calendar.getTimeInMillis());
        }
        return 0;
    }

    public static int getValue(byte[] data) {
        return HealthThermometerServiceUtil.decodeTemperature(data);
    }

    public static int decodeTemperature(byte[] data) {
        byte flag = data[0];
        byte exponential = data[4];
        short firstOctet = HealthThermometerServiceUtil.convertNegativeByteToPositiveShort(data[1]);
        short secondOctet = HealthThermometerServiceUtil.convertNegativeByteToPositiveShort(data[2]);
        short thirdOctet = HealthThermometerServiceUtil.convertNegativeByteToPositiveShort(data[3]);
        int mantissa = (thirdOctet << 16 | secondOctet << 8 | firstOctet) & 0xFFFFFF;
        mantissa = HealthThermometerServiceUtil.getTwosComplimentOfNegativeMantissa(mantissa);
        double temperatureValue = (double)mantissa * Math.pow(10.0, exponential);
        if ((flag & 1) != 0) {
            temperatureValue = (98.6 * temperatureValue - 32.0) * 0.5555555555555556;
        }
        return (int)Math.round(temperatureValue * 100.0);
    }

    private static short convertNegativeByteToPositiveShort(byte octet) {
        if (octet < 0) {
            return (short)(octet & 0xFF);
        }
        return octet;
    }

    private static int getTwosComplimentOfNegativeMantissa(int mantissa) {
        if ((mantissa & 0x400000) != 0) {
            return ((~mantissa & 0xFFFFFF) + 1) * -1;
        }
        return mantissa;
    }

    public static int getCalculateFlag(byte[] data) {
        if (data == null || data.length <= 11) {
            return 0;
        }
        byte c4 = data[12];
        if ((c4 & 0x80) != 0) {
            int time = c4 & 0x7F;
            Logger.i((String)("ble calculate flag : " + time), (Object[])new Object[0]);
            return time;
        }
        return 0;
    }

    public static int getSmartThermoValue(byte[] data) {
        byte exponential = data[4];
        short firstOctet = HealthThermometerServiceUtil.convertNegativeByteToPositiveShort(data[1]);
        short secondOctet = HealthThermometerServiceUtil.convertNegativeByteToPositiveShort(data[2]);
        short thirdOctet = HealthThermometerServiceUtil.convertNegativeByteToPositiveShort(data[3]);
        int mantissa = (thirdOctet << 16 | secondOctet << 8 | firstOctet) & 0xFFFFFF;
        mantissa = HealthThermometerServiceUtil.getTwosComplimentOfNegativeMantissa(mantissa);
        double temperatureValue = (double)mantissa * Math.pow(10.0, exponential);
        return (int)Math.round(temperatureValue * 100.0);
    }

    public static int getSmartThermoUserId(byte[] data) {
        if (data == null || data.length <= 11) {
            return 0;
        }
        return data[12];
    }
}

