/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.utils;

import android.content.Context;
import cn.lollypop.android.thermometer.ble.model.DeviceDebugInfo;
import com.basic.util.ByteUtil;
import com.basic.util.GsonUtil;

public class CustomServiceUtil {
    public static final byte[] DEVICE_SLEEP = new byte[]{-120};
    public static final byte[] REFRESH_ALARM = new byte[]{1};
    public static final byte[] REFRESH_DEBUG_INFO = new byte[]{2};
    public static final byte[] REFRESH_CURRENT_VOLTAGE = new byte[]{3};
    public static final byte[] REFRESH_INDOOR_TEMPERATURE = new byte[]{5};
    public static final byte[] ENTER_DEBUG = new byte[]{-2};
    public static final byte[] QUIT_DEBUG = new byte[]{-1};
    public static final byte[] TRIGGER_BEEP = new byte[]{-3};
    private static final DeviceDebugInfo deviceDebugInfo = new DeviceDebugInfo();

    public static void setDebugInfo(Context context, byte[] data) {
        if (data == null) {
            return;
        }
        int restartTimes = ByteUtil.getInt((byte)data[0]);
        int runningTimeSecs = ByteUtil.reverse((byte[])new byte[]{data[1], data[2], data[3], data[4]});
        int measureTimes = ByteUtil.reverse((byte[])new byte[]{data[5], data[6]});
        int beepTimes = ByteUtil.reverse((byte[])new byte[]{data[7], data[8]});
        int wakeUpTimes = ByteUtil.reverse((byte[])new byte[]{data[9], data[10]});
        int sleepTimes = ByteUtil.reverse((byte[])new byte[]{data[11], data[12]});
        int alarmTimes = ByteUtil.reverse((byte[])new byte[]{data[13], data[14]});
        int openCapTimes = ByteUtil.reverse((byte[])new byte[]{data[15], data[16]});
        int closeCapTimes = ByteUtil.reverse((byte[])new byte[]{data[17], data[18]});
        int measureFailureTimes = 0;
        if (data.length >= 20) {
            measureFailureTimes = ByteUtil.getInt((byte)data[19]);
        }
        deviceDebugInfo.setRestartTimes((short)restartTimes);
        deviceDebugInfo.setRunningTimeSecs(runningTimeSecs);
        deviceDebugInfo.setMeasureTimes((short)measureTimes);
        deviceDebugInfo.setBeepTimes((short)beepTimes);
        deviceDebugInfo.setWakeUpTimes((short)wakeUpTimes);
        deviceDebugInfo.setSleepTimes((short)sleepTimes);
        deviceDebugInfo.setAlarmTimes((short)alarmTimes);
        deviceDebugInfo.setOpenCapTimes((short)openCapTimes);
        deviceDebugInfo.setCloseCapTimes((short)closeCapTimes);
        deviceDebugInfo.setMeasureFailureTimes((short)measureFailureTimes);
    }

    public static String getDeviceInfo() {
        return GsonUtil.getGson().toJson((Object)deviceDebugInfo);
    }

    public static void setCurrentVoltage(Context context, byte[] data) {
        if (data == null) {
            return;
        }
        int b = ByteUtil.reverse((byte[])data);
        deviceDebugInfo.setCurrentVoltage((short)b);
    }

    public static void setBatteryLevel(Context context, int batteryLevel) {
        deviceDebugInfo.setBatteryLevel((short)batteryLevel);
    }

    public static void setIndoorTemperature(Context context, byte[] data) {
        if (data == null) {
            return;
        }
        int b = ByteUtil.reverse((byte[])data);
        deviceDebugInfo.setIndoorTemperature((short)b);
    }
}

