/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.ota;

import com.basic.util.CommonUtil;
import com.orhanobut.logger.Logger;
import java.io.IOException;
import java.io.InputStream;

public class PatchData {
    public static final int BLOCK_LENGth = 240;
    public static final int BYTE_LENGth = 20;
    private byte[] bytes;
    private int total;
    private int offset = 0;

    public PatchData(InputStream is) {
        try {
            this.total = is.available();
            this.bytes = CommonUtil.convertInputStreamToByteArray((InputStream)is);
            Logger.d((Object)("\u8bfb\u53d6\u5230\u7684\u6570\u636e\u957f\u5ea6\uff1a" + this.bytes.length + " " + this.total));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Block getNext() {
        if (this.total > 0 && this.offset != this.total) {
            int count = 240;
            if (this.offset + 240 > this.total) {
                count = this.total - this.offset;
            }
            Logger.d((Object)("block len : " + count));
            byte[] temp = new byte[count];
            System.arraycopy(this.bytes, this.offset, temp, 0, count);
            this.offset += count;
            return new Block(temp.length, temp);
        }
        return null;
    }

    public boolean isEnd() {
        return this.offset == this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public float getProgress() {
        return CommonUtil.convertDoubleToFloat((double)((double)this.offset * 1.0 / (double)this.total));
    }

    public class Block {
        private int len;
        private byte[] data;
        private int shift;

        public Block(int len, byte[] data) {
            this.len = len;
            this.data = data;
            this.shift = 0;
        }

        public byte[] getNextBytes() {
            int count = 20;
            if (this.shift + 20 > this.len) {
                count = this.len - this.shift;
            }
            Logger.d((Object)("byte len : " + count));
            byte[] temp = new byte[count];
            System.arraycopy(this.data, this.shift, temp, 0, count);
            this.shift += count;
            return temp;
        }

        public boolean isEnd() {
            return this.shift == this.len;
        }

        public int getLen() {
            return this.len;
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

