/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.ota;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Environment;
import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.ota.GattAttributes;
import cn.lollypop.android.thermometer.ble.ota.PatchData;
import cn.lollypop.android.thermometer.ble.utils.DeviceInformationServiceUtil;
import com.basic.util.ClsUtil;
import com.basic.util.CommonUtil;
import com.orhanobut.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;

public class OtaManager {
    public static final UUID UUID_OTA_SERVICE = UUID.fromString("0000fef5-0000-1000-8000-00805f9b34fb");
    public static final UUID UUID_OTA_MEM_DEV_UUID = UUID.fromString("8082caa8-41a6-4021-91c6-56f9b954cc34");
    public static final UUID UUID_OTA_GPIO_MAP_UUID = UUID.fromString("724249f0-5ec3-4b5f-8804-42345af08651");
    public static final UUID UUID_OTA_MEM_INFO_UUID = UUID.fromString("6c53db25-47a1-45fe-a022-7c92fb334fd4");
    public static final UUID UUID_OTA_PATCH_LEN_UUID = UUID.fromString("9d84b9a3-000c-49d8-9183-855b673fda31");
    public static final UUID UUID_OTA_PATCH_DATA_UUID = UUID.fromString("457871e8-d516-4ca1-9116-57d0b17b9cb2");
    public static final UUID UUID_OTA_SERV_STATUS_UUID = UUID.fromString("5f78df94-798c-46f5-990a-b3eb6a065c88");
    private BluetoothGattCharacteristic otaMemDevCharacteristic;
    private BluetoothGattCharacteristic otaGpioMapCharacteristic;
    private BluetoothGattCharacteristic otaMemInfoCharacteristic;
    private BluetoothGattCharacteristic otaPatchLenCharacteristic;
    private BluetoothGattCharacteristic otaPatchDataCharacteristic;
    private BluetoothGattCharacteristic otaServStatusCharacteristic;
    private int step;
    private boolean isSendData;
    private PatchData patchData;
    private PatchData.Block block;
    private BluetoothGatt bluetoothGatt;
    private BleCallback bleCallback;
    private String serverVersion;
    private Context context;

    public boolean isTransferring() {
        return this.step > 0;
    }

    public void initCharacteristic(BluetoothGattService gattService) {
        if (UUID_OTA_SERVICE.equals(gattService.getUuid())) {
            for (BluetoothGattCharacteristic gattCharacteristic : gattService.getCharacteristics()) {
                if (UUID_OTA_GPIO_MAP_UUID.equals(gattCharacteristic.getUuid())) {
                    this.otaGpioMapCharacteristic = gattCharacteristic;
                    continue;
                }
                if (UUID_OTA_MEM_DEV_UUID.equals(gattCharacteristic.getUuid())) {
                    this.otaMemDevCharacteristic = gattCharacteristic;
                    continue;
                }
                if (UUID_OTA_MEM_INFO_UUID.equals(gattCharacteristic.getUuid())) {
                    this.otaMemInfoCharacteristic = gattCharacteristic;
                    continue;
                }
                if (UUID_OTA_PATCH_DATA_UUID.equals(gattCharacteristic.getUuid())) {
                    this.otaPatchDataCharacteristic = gattCharacteristic;
                    continue;
                }
                if (UUID_OTA_PATCH_LEN_UUID.equals(gattCharacteristic.getUuid())) {
                    this.otaPatchLenCharacteristic = gattCharacteristic;
                    continue;
                }
                if (!UUID_OTA_SERV_STATUS_UUID.equals(gattCharacteristic.getUuid())) continue;
                this.otaServStatusCharacteristic = gattCharacteristic;
            }
        }
    }

    public void start(Context context, String serverVersion, BluetoothGatt bluetoothGatt, BleCallback bleCallback) {
        this.bluetoothGatt = bluetoothGatt;
        this.bleCallback = bleCallback;
        this.serverVersion = serverVersion;
        this.context = context;
        File file = this.getFile(context);
        if (file == null) {
            this.refreshView(BleCallback.BleStatus.OPERATE_FAIL, null);
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            Logger.i((String)("ota img size : " + ((InputStream)is).available()), (Object[])new Object[0]);
            this.patchData = new PatchData(is);
            this.step = 0;
            if (this.patchData.getTotal() > 0) {
                this.setStartAddress();
            } else {
                this.otaError();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.refreshView(BleCallback.BleStatus.OPERATE_FAIL, null);
        }
    }

    public boolean ackWrite(BluetoothGattCharacteristic characteristic, int status) {
        if (UUID_OTA_MEM_DEV_UUID.equals(characteristic.getUuid())) {
            if (!Arrays.equals(GattAttributes.ADDRESS_RESET, characteristic.getValue())) {
                this.readServStatus();
            }
            return true;
        }
        if (UUID_OTA_GPIO_MAP_UUID.equals(characteristic.getUuid())) {
            this.readServStatus();
            return true;
        }
        if (UUID_OTA_MEM_INFO_UUID.equals(characteristic.getUuid())) {
            this.readServStatus();
            return true;
        }
        if (UUID_OTA_PATCH_LEN_UUID.equals(characteristic.getUuid())) {
            this.readServStatus();
            return true;
        }
        if (UUID_OTA_PATCH_DATA_UUID.equals(characteristic.getUuid())) {
            if (this.block.isEnd()) {
                this.readServStatus();
            } else {
                this.sendData(this.block);
            }
            return true;
        }
        return false;
    }

    public boolean ackRead(BluetoothGattCharacteristic characteristic, int status) {
        if (UUID_OTA_SERV_STATUS_UUID.equals(characteristic.getUuid())) {
            byte[] value = characteristic.getValue();
            if (Arrays.equals(value, new byte[]{16}) || Arrays.equals(value, new byte[]{1}) || Arrays.equals(value, new byte[]{2}) || Arrays.equals(value, new byte[]{3})) {
                switch (this.step) {
                    case 0: {
                        Logger.i((String)"OTA set start address\uff0cnext to set GPIO", (Object[])new Object[0]);
                        ++this.step;
                        this.setGPIO();
                        break;
                    }
                    case 1: {
                        Logger.i((String)"OTA set GPIO\uff0cnext to send data", (Object[])new Object[0]);
                        ++this.step;
                        this.sendNextBlock();
                        break;
                    }
                    case 2: {
                        if (!this.isSendData) {
                            this.isSendData = true;
                        }
                        this.sendBlock();
                        break;
                    }
                    case 3: {
                        Logger.i((String)"OTA set end address\uff0c next to reboot", (Object[])new Object[0]);
                        this.setRest();
                        break;
                    }
                }
            } else {
                String error = "OTA error!";
                if (value != null && value.length > 0) {
                    error = error + " return error value :" + ClsUtil.Bytes2HexString((byte[])value);
                }
                Logger.i((String)error, (Object[])new Object[0]);
                this.otaError();
            }
            return true;
        }
        return false;
    }

    private void setStartAddress() {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.otaMemDevCharacteristic.setValue(GattAttributes.ADDRESS_START);
        this.bluetoothGatt.writeCharacteristic(this.otaMemDevCharacteristic);
    }

    private void setEndAddress() {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.otaMemDevCharacteristic.setValue(GattAttributes.ADDRESS_END);
        this.bluetoothGatt.writeCharacteristic(this.otaMemDevCharacteristic);
    }

    private void setRest() {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.otaMemDevCharacteristic.setValue(GattAttributes.ADDRESS_RESET);
        this.bluetoothGatt.writeCharacteristic(this.otaMemDevCharacteristic);
        this.step = 0;
        DeviceInformationServiceUtil.setFirmwareVersion(this.context, this.serverVersion);
        this.refreshView(BleCallback.BleStatus.END_OTA, null);
    }

    private void setGPIO() {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.otaGpioMapCharacteristic.setValue(GattAttributes.GPIO);
        this.bluetoothGatt.writeCharacteristic(this.otaGpioMapCharacteristic);
    }

    private void sendNextBlock() {
        this.isSendData = false;
        this.block = this.patchData.getNext();
        this.sendBlock();
        this.refreshView(BleCallback.BleStatus.PROGRESS_OTA, CommonUtil.convertFloatToInt((float)this.patchData.getProgress(), (int)100));
    }

    private void sendBlock() {
        if (!this.isSendData) {
            this.setFileLength(this.block.getLen());
        } else if (this.block.isEnd()) {
            if (this.patchData.isEnd()) {
                ++this.step;
                Logger.i((String)"OTA send data successfully\uff0cnext to set end address", (Object[])new Object[0]);
                this.setEndAddress();
            } else {
                this.sendNextBlock();
            }
        } else {
            this.sendData(this.block);
        }
    }

    private void setFileLength(int len) {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.otaPatchLenCharacteristic.setValue(len, 18, 0);
        this.bluetoothGatt.writeCharacteristic(this.otaPatchLenCharacteristic);
    }

    private void readServStatus() {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.bluetoothGatt.readCharacteristic(this.otaServStatusCharacteristic);
    }

    private void sendData(PatchData.Block block) {
        if (this.bluetoothGatt == null) {
            this.otaError();
            return;
        }
        this.otaPatchDataCharacteristic.setValue(block.getNextBytes());
        this.bluetoothGatt.writeCharacteristic(this.otaPatchDataCharacteristic);
    }

    private void refreshView(BleCallback.BleStatus bleState, Object obj) {
        this.bleCallback.callback(bleState, obj);
    }

    private void otaError() {
        this.refreshView(BleCallback.BleStatus.OPERATE_FAIL, null);
    }

    public File getFile(Context context) {
        File[] files;
        File path = context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
        if (path != null && (files = path.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (!file.getName().equals(this.serverVersion)) continue;
                return file;
            }
        }
        return null;
    }

    public static boolean checkExist(Context context, String version) {
        File[] files;
        File path = context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
        if (path != null && (files = path.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (!file.getName().equals(version)) continue;
                return true;
            }
        }
        return false;
    }
}

