/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.action.request.BleRequestActionType;
import cn.lollypop.android.thermometer.ble.action.request.BleRequestValueType;
import com.basic.util.ClsUtil;
import java.util.UUID;

public class BleRequest {
    protected UUID characteristicUUID;
    protected BleRequestActionType actionType;
    protected byte[] value;
    protected int valueInt;
    protected BleRequestValueType valueType;
    protected int offset;
    protected boolean valueBoolean;
    protected BleCallback.BleStatus currentBleStatus;
    protected Object object;

    public BleRequest() {
    }

    public BleRequest(UUID uuid, BleRequestActionType actionType) {
        this.characteristicUUID = uuid;
        this.actionType = actionType;
        this.valueType = BleRequestValueType.NO_VALUE;
    }

    public BleRequest(UUID uuid, BleRequestActionType actionType, byte[] value) {
        this.characteristicUUID = uuid;
        this.actionType = actionType;
        this.value = value;
        this.valueType = BleRequestValueType.BYTE;
    }

    public BleRequest(UUID uuid, BleRequestActionType actionType, int value, int offset) {
        this.characteristicUUID = uuid;
        this.actionType = actionType;
        this.valueInt = value;
        this.offset = offset;
        this.valueType = BleRequestValueType.UINT16;
    }

    public BleRequest(UUID uuid, BleRequestActionType actionType, boolean b) {
        this.characteristicUUID = uuid;
        this.actionType = actionType;
        this.valueBoolean = b;
        this.valueType = BleRequestValueType.BOOLEAN;
    }

    public boolean analyzeData(Context context, byte[] data) {
        return true;
    }

    public UUID getCharacteristicUUID() {
        return this.characteristicUUID;
    }

    public void setCharacteristicUUID(UUID characteristicUUID) {
        this.characteristicUUID = characteristicUUID;
    }

    public BleRequestActionType getActionType() {
        return this.actionType;
    }

    public void setActionType(BleRequestActionType actionType) {
        this.actionType = actionType;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public BleRequestValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(BleRequestValueType valueType) {
        this.valueType = valueType;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getValueInt() {
        return this.valueInt;
    }

    public void setValueInt(int valueInt) {
        this.valueInt = valueInt;
    }

    public boolean isValueBoolean() {
        return this.valueBoolean;
    }

    public void setValueBoolean(boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
    }

    public BleCallback.BleStatus getCurrentBleStatus() {
        return this.currentBleStatus;
    }

    public Object getObject() {
        return this.object;
    }

    public String toString() {
        String valueStr = "";
        if (this.value != null) {
            valueStr = ClsUtil.Bytes2HexString((byte[])this.value);
        }
        return this.characteristicUUID + "\uff0c" + this.actionType.toString() + "\uff0c" + valueStr;
    }
}

