package cn.lollypop.android.thermometer.ble.utils;

import android.content.Context;
import com.basic.util.ByteUtil;
import com.basic.util.GsonUtil;

import cn.lollypop.android.thermometer.ble.model.DeviceDebugInfo;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class CustomServiceUtil {
  public static final byte[] DEVICE_SLEEP = new byte[]{(byte) 0x88};
  public static final byte[] REFRESH_ALARM = new byte[]{0x01};
  public static final byte[] REFRESH_DEBUG_INFO = new byte[]{(byte) 0x02};
  public static final byte[] REFRESH_CURRENT_VOLTAGE = new byte[]{(byte) 0x03};
  public static final byte[] REFRESH_INDOOR_TEMPERATURE =
      new byte[]{(byte) 0x05};
  public static final byte[] ENTER_DEBUG = new byte[]{(byte) 0xFE};
  public static final byte[] QUIT_DEBUG = new byte[]{(byte) 0xFF};
  public static final byte[] TRIGGER_BEEP = new byte[]{(byte) 0xFD};

  private static final DeviceDebugInfo deviceDebugInfo = new DeviceDebugInfo();

  public static void setDebugInfo(Context context, byte[] data) {
    if (data == null) {
      return;
    }

    int restartTimes = ByteUtil.getInt(data[0]);
    int runningTimeSecs = ByteUtil.reverse(data[1], data[2], data[3], data[4]);
    int measureTimes = ByteUtil.reverse(data[5], data[6]);
    int beepTimes = ByteUtil.reverse(data[7], data[8]);
    int wakeUpTimes = ByteUtil.reverse(data[9], data[10]);
    int sleepTimes = ByteUtil.reverse(data[11], data[12]);
    int alarmTimes = ByteUtil.reverse(data[13], data[14]);
    int openCapTimes = ByteUtil.reverse(data[15], data[16]);
    int closeCapTimes = ByteUtil.reverse(data[17], data[18]);
    int measureFailureTimes = 0;
    if (data.length >= 20) {
      measureFailureTimes = ByteUtil.getInt(data[19]);
    }

    deviceDebugInfo.setRestartTimes((short) restartTimes);
    deviceDebugInfo.setRunningTimeSecs(runningTimeSecs);
    deviceDebugInfo.setMeasureTimes((short) measureTimes);
    deviceDebugInfo.setBeepTimes((short) beepTimes);
    deviceDebugInfo.setWakeUpTimes((short) wakeUpTimes);
    deviceDebugInfo.setSleepTimes((short) sleepTimes);
    deviceDebugInfo.setAlarmTimes((short) alarmTimes);
    deviceDebugInfo.setOpenCapTimes((short) openCapTimes);
    deviceDebugInfo.setCloseCapTimes((short) closeCapTimes);
    deviceDebugInfo.setMeasureFailureTimes((short) measureFailureTimes);
  }

  public static String getDeviceInfo() {
    return GsonUtil.getGson().toJson(deviceDebugInfo);
  }

  public static void setCurrentVoltage(Context context, byte[] data) {
    if (data == null) {
      return;
    }

    int b = ByteUtil.reverse(data);
    deviceDebugInfo.setCurrentVoltage((short) b);
  }

  public static void setBatteryLevel(Context context, int batteryLevel) {
    deviceDebugInfo.setBatteryLevel((short) batteryLevel);
  }

  public static void setIndoorTemperature(Context context, byte[] data) {
    if (data == null) {
      return;
    }

    int b = ByteUtil.reverse(data);
    deviceDebugInfo.setIndoorTemperature((short) b);
  }
}