package cn.lollypop.android.thermometer.ble.utils;

import java.util.Calendar;

import com.basic.util.ByteUtil;
import com.basic.util.TimeUtil;

public class CurrentTimeServiceUtil {
  public static final byte[] READ = new byte[]{0x01};

  public static int getTimestamp(byte[] data) {
    try {
      int year = ByteUtil.getShort(new byte[]{data[0], data[1]});
      int month = data[2];
      int day = data[3];
      int hour = data[4];
      int min = data[5];
      int sec = data[6];
      Calendar calendar = Calendar.getInstance();
      calendar.set(year, month - 1, day, hour, min, sec);
      return TimeUtil.getTimestamp(calendar.getTimeInMillis());
    } catch (Exception e) {
      return 0;
    }
  }

  public static int getWeek(byte[] data) {
    return data[7];
  }

  public static byte[] getDate(int timestamp, int week) {
    byte[] data = new byte[8];
    Calendar calendar = Calendar.getInstance();
    calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
    byte[] year = ByteUtil.getBytes((short) calendar.get(Calendar.YEAR));
    data[0] = year[0];
    data[1] = year[1];
    data[2] = (byte) (calendar.get(Calendar.MONTH) + 1);
    data[3] = (byte) calendar.get(Calendar.DAY_OF_MONTH);
    data[4] = (byte) calendar.get(Calendar.HOUR_OF_DAY);
    data[5] = (byte) calendar.get(Calendar.MINUTE);
    data[6] = (byte) calendar.get(Calendar.SECOND);
    data[7] = (byte) week;
    return data;
  }
}
