package cn.lollypop.android.thermometer.ble.utils;

import android.content.Context;
import android.text.TextUtils;
import com.basic.util.ACache;
import com.orhanobut.logger.Logger;

public class BatteryServiceUtil {

  public static int getBatteryLevel(byte[] data) {
    if (data == null) {
      return 0;
    }

    return data[0];
  }

  public static int getBatteryLevel(Context context) {
    String battery = ACache.get(context).getAsString("battery");
    if (!TextUtils.isEmpty(battery)) {
      try {
        return Integer.parseInt(battery);
      } catch (NumberFormatException e) {
        Logger.e("battery NA");
      }
    }
    return 0;
  }

  public static void setBatteryLevel(Context context, int level) {
    // ACache 不能直接put整数
    ACache.get(context).put("battery", level + "");
  }
}