package cn.lollypop.android.thermometer.ble.utils;

import java.util.Calendar;
import java.util.Date;

import cn.lollypop.android.thermometer.ble.exceptions.BleException;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;

public class AlarmTimeServiceUtil {

  /**
   * 体温计当前系统时间.
   *
   * @param bs bytes
   * @return 时间
   * @throws BleException
   */
  public static Date getThermometerSystemTime(byte[] bs) throws BleException {
    if (bs == null || bs.length != 10) {
      throw new BleException(BleException.LENGTH_ERROR);
    }
    int year = bs[0] + 2000;
    Calendar c = Calendar.getInstance();
    c.set(year, bs[1], bs[2], bs[4], bs[5], bs[6]);
    return c.getTime();
  }

  /**
   * 闹钟周，0表示没闹钟.
   *
   * @param bs bytes
   * @return int
   * @throws BleException
   */
  public static int getAlarmWeek(byte[] bs) throws BleException {
    if (bs == null || bs.length != 10) {
      throw new BleException(BleException.LENGTH_ERROR);
    }
    return bs[7];
  }

  /**
   * 闹钟时.
   *
   * @param bs bytes
   * @return int
   * @throws BleException
   */
  public static int getAlarmHour(byte[] bs) throws BleException {
    if (bs == null || bs.length != 10) {
      throw new BleException(BleException.LENGTH_ERROR);
    }
    return bs[8];
  }

  /**
   * 闹钟分.
   *
   * @param bs bytes
   * @return int
   * @throws BleException
   */
  public static int getAlarmMin(byte[] bs) throws BleException {
    if (bs == null || bs.length != 10) {
      throw new BleException(BleException.LENGTH_ERROR);
    }
    return bs[9];
  }

  /**
   * 生成要设置的闹钟时间.
   *
   * @return bytes
   */
  public static byte[] generateSendData(AlarmTimeModel temp) {
    if (temp == null) {
      return new byte[]{0, 0, 0};
    }
    return temp.generateAlarm();
  }
}
