package cn.lollypop.android.thermometer.ble.ota;

import java.io.IOException;
import java.io.InputStream;

import com.basic.util.CommonUtil;
import com.orhanobut.logger.Logger;

public class PatchData {

  public static final int BLOCK_LENGth = 240;
  public static final int BYTE_LENGth = 20;
  private byte[] bytes;
  private int total;
  private int offset;

  public PatchData(InputStream is) {
    offset = 0;
    try {
      total = is.available();
      bytes = CommonUtil.convertInputStreamToByteArray(is);
      Logger.d("读取到的数据长度：" + bytes.length + " " + total);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public Block getNext() {
    if (total > 0 && offset != total) {
      int count = BLOCK_LENGth;
      if (offset + BLOCK_LENGth > total) { //剩余不到额定大小
        count = total - offset;
      }
      Logger.d("block len : " + count);
      byte[] temp = new byte[count];
      System.arraycopy(bytes, offset, temp, 0, count);
      offset += count;
      return new Block(temp.length, temp);
    }
    return null;
  }

  public boolean isEnd() {
    return offset == total;
  }

  public int getTotal() {
    return total;
  }

  public float getProgress() {
    return CommonUtil.convertDoubleToFloat(offset * 1.0 / total);
  }

  /**
   * 数据分块.
   */
  public class Block {
    private int len;
    private byte[] data;

    private int shift;

    public Block(int len, byte[] data) {
      this.len = len;
      this.data = data;
      shift = 0;
    }

    public byte[] getNextBytes() {
      int count = BYTE_LENGth;
      if (shift + BYTE_LENGth > len) { //剩余不到额定大小
        count = len - shift;
      }
      Logger.d("byte len : " + count);
      byte[] temp = new byte[count];
      System.arraycopy(data, shift, temp, 0, count);
      shift += count;
      return temp;
    }

    public boolean isEnd() {
      return shift == len;
    }

    public int getLen() {
      return len;
    }

    public byte[] getData() {
      return data;
    }
  }
}
