package cn.lollypop.android.thermometer.ble.ota;

/**
 * Software Patching Over the Air.
 * 写入开始地址，写入GPIO，循环发送BLOCK( 一个BLOCK的len默认200字节，
 * 20字节一次发送data，发完一个BLOCK发下一个BLOCK ),
 * IMG全部发送结束后写入结束地址，写入重置地址
 * 01,02,03,10表示正常状态，其他表示错误状态
 */
public class GattAttributes {
  public static final String SPOTA_SERVICE =
      "0000fef5-0000-1000-8000-00805f9b34fb";

  //地址 开始写入00000013，结束写入000000FE校验，重启写入000000FD
  public static final String SPOTA_MEM_DEV_UUID =
      "8082caa8-41a6-4021-91c6-56f9b954cc34";

  //GPIO 00030605 (WRITE)
  public static final String SPOTA_GPIO_MAP_UUID =
      "724249f0-5ec3-4b5f-8804-42345af08651";

  //READ
  public static final String SPOTA_MEM_INFO_UUID =
      "6c53db25-47a1-45fe-a022-7c92fb334fd4";

  //长度 IMG长度 (WRITE)
  public static final String SPOTA_PATCH_LEN_UUID =
      "9d84b9a3-000c-49d8-9183-855b673fda31";

  //数据 20字节发一次 (WRITE)
  public static final String SPOTA_PATCH_DATA_UUID =
      "457871e8-d516-4ca1-9116-57d0b17b9cb2";

  //反馈 01,02,03,10表示正常，其他失败(READ)
  public static final String SPOTA_SERV_STATUS_UUID =
      "5f78df94-798c-46f5-990a-b3eb6a065c88";

  public static final byte[] ADDRESS_START = new byte[]{
      0x00, 0x00, 0x00, 0x13};

  public static final byte[] ADDRESS_END = new byte[]{
      0x00, 0x00, 0x00, (byte) 0xFE};

  public static final byte[] ADDRESS_RESET = new byte[]{
      0x00, 0x00, 0x00, (byte) 0xFD};

  public static final byte[] GPIO = new byte[]{0x00, 0x03, 0x06, 0x05};
}