package cn.lollypop.android.thermometer.ble.action.response;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class BleResponse {
  private BleResponseType type;
  private int status;
  private BluetoothGattDescriptor descriptor;
  private BluetoothGattCharacteristic characteristic;

  public BleResponse(BluetoothGattDescriptor descriptor, int status) {
    this.descriptor = descriptor;
    this.status = status;
    type = BleResponseType.DESCRIPTOR;
  }

  public BleResponse(BluetoothGattCharacteristic characteristic, int status) {
    this.characteristic = characteristic;
    this.status = status;
    type = BleResponseType.CHARACTERISTIC;
  }

  public BleResponseType getType() {
    return type;
  }

  public void setType(BleResponseType type) {
    this.type = type;
  }

  public int getStatus() {
    return status;
  }

  public void setStatus(int status) {
    this.status = status;
  }

  public BluetoothGattDescriptor getDescriptor() {
    return descriptor;
  }

  public void setDescriptor(BluetoothGattDescriptor descriptor) {
    this.descriptor = descriptor;
  }

  public BluetoothGattCharacteristic getCharacteristic() {
    return characteristic;
  }

  public void setCharacteristic(BluetoothGattCharacteristic characteristic) {
    this.characteristic = characteristic;
  }
}
