package cn.lollypop.android.thermometer.ble.action.request;

import java.util.Arrays;

import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.Constants;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class TemperatureIndicationRequest extends BleRequest {
  public TemperatureIndicationRequest(byte[] value) {
    this.characteristicUUID = Constants.UUID_TEMPERATE_MEASUREMENT;
    this.actionType = BleRequestActionType.SET_INDICATION;
    this.valueType = BleRequestValueType.BYTE;

    this.value = value;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    if (Arrays.equals(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE,
        value)) {
      // 关闭测温
      Logger.i("ble stop listening temperature， begin OTA");
      currentBleStatus = BleCallback.BleStatus.START_OTA;
    }
    return true;
  }
}
