package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.DeviceInformationServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class SNRevisionRequest extends BleRequest {
  public SNRevisionRequest() {
    characteristicUUID = Constants.UUID_SN;
    actionType = BleRequestActionType.READ;
    valueType = BleRequestValueType.NO_VALUE;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    String version = DeviceInformationServiceUtil.getSNRevision(data);
    DeviceInformationServiceUtil.setSN(context, version);
    version = DeviceInformationServiceUtil.getSN(context);
    Logger.i("ble get sn revision : " + version);
    return !"".equals(version);
  }
}