package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.basic.util.TimeUtil;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.CurrentTimeServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class ReadDeviceTimeRequest extends BleRequest {

  public static int deviceTimeOffset;

  public ReadDeviceTimeRequest() {
    characteristicUUID = Constants.UUID_CURRENT_TIME;
    actionType = BleRequestActionType.READ;
    valueType = BleRequestValueType.NO_VALUE;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    int timestamp = CurrentTimeServiceUtil.getTimestamp(data);
    int interval = TimeUtil.getTimestamp(System.currentTimeMillis())
        - timestamp;
    deviceTimeOffset = interval;
    Logger.i("ble original time : " + timestamp + " , "
        + "time offset:" + interval);
    return true;
  }
}