package cn.lollypop.android.thermometer.ble.action.request;

import java.util.Calendar;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.CurrentTimeServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class CurrentTimeWriteRequest extends BleRequest {
  public CurrentTimeWriteRequest(int currentTime) {
    this.characteristicUUID = Constants.UUID_CURRENT_TIME;
    this.actionType = BleRequestActionType.WRITE;
    this.valueType = BleRequestValueType.BYTE;

    this.value = CurrentTimeServiceUtil.getDate(
        currentTime, Calendar.getInstance().get(Calendar.DAY_OF_WEEK)
    );
  }
}
