package cn.lollypop.android.thermometer.ble.action.request;

import android.content.Context;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.Constants;
import cn.lollypop.android.thermometer.ble.utils.CurrentTimeServiceUtil;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class CurrentTimeReadRequest extends BleRequest {

  private int currentTime;

  public CurrentTimeReadRequest(int currentTime) {
    characteristicUUID = Constants.UUID_CURRENT_TIME;
    actionType = BleRequestActionType.READ;
    valueType = BleRequestValueType.NO_VALUE;

    this.currentTime = currentTime;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    //读取到设备当前时间
    int timestamp = CurrentTimeServiceUtil.getTimestamp(data);
    int interval = Math.abs(currentTime - timestamp);
    Logger.i("ble get current time data : " + timestamp + " , " +
        "set current time data : " + currentTime + " , interval : " + interval);
    if (interval <= 300) {
      Logger.i("ble set current time successfully！");
      return true;
    } else {
      Logger.i("ble set current time failed！");
      return false;
    }
  }
}