package cn.lollypop.android.thermometer.ble.action.request;

import java.util.Arrays;

import android.content.Context;
import com.basic.util.ClsUtil;
import com.orhanobut.logger.Logger;

import cn.lollypop.android.thermometer.ble.BleCallback;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public class AlarmReadRequest extends BaseCustomReadRequest {
  public static byte[] alarmBytesTemp;

  public AlarmReadRequest(byte[] temp) {
    super();

    alarmBytesTemp = temp;
  }

  @Override
  public boolean analyzeData(Context context, byte[] data) {
    Logger.i("ble set alarm data : " + ClsUtil.Bytes2HexString(alarmBytesTemp)
        + ", ble get alarm data : " + ClsUtil.Bytes2HexString(data));
    if (Arrays.equals(alarmBytesTemp, data)) {
      Logger.i("ble set alarm successfully");
      currentBleStatus = BleCallback.BleStatus.SET_ALARM;
      object = AlarmTimeModel.getSingle(context);
      return true;
    } else {
      Logger.i("set alarm failed");
      return false;
    }
  }
}
