package cn.lollypop.android.thermometer.ble.action;

import java.util.List;

import android.content.Context;

import cn.lollypop.android.thermometer.ble.action.request.BleRequest;
import cn.lollypop.android.thermometer.ble.model.AlarmTimeModel;

/**
 * Copyright (c) 2015, Bongmi
 * All rights reserved
 * Author: wangjunjie@bongmi.com
 */
public interface IBleAction {
  List<BleRequest> initConnect(Context context,
                               boolean switchOriginalTemperature);

  List<BleRequest> setAlarm(AlarmTimeModel alarmTimeModel);

  List<BleRequest> startMeasure(boolean switchOriginalTemperature);

  List<BleRequest> getBatteryLevel();

  List<BleRequest> doOta();

  List<BleRequest> makeDeviceSleep();

  List<BleRequest> enterDebugMode();

  List<BleRequest> quitDebugMode();

  List<BleRequest> triggerBeep();
}
