/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import com.base.libs.R;
import com.basic.widgets.TosGallery;

public class WheelView
extends TosGallery {
    private Drawable mSelectorDrawable = null;
    private Rect mSelectorBound = new Rect();
    private GradientDrawable mTopShadow = null;
    private GradientDrawable mBottomShadow = null;
    private static final int[] SHADOWS_COLORS = new int[]{-1, 0xFFFFFF, 0xFFFFFF};

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setVerticalScrollBarEnabled(false);
        this.setSlotInCenter(true);
        this.setOrientation(2);
        this.setGravity(1);
        this.setUnselectedAlpha(1.0f);
        this.setWillNotDraw(false);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.WheelView);
        int bg = ta.getResourceId(R.styleable.WheelView_bg, 0);
        int selector = ta.getResourceId(R.styleable.WheelView_selector, 0);
        ta.recycle();
        if (selector > 0) {
            this.mSelectorDrawable = this.getContext().getResources().getDrawable(selector);
        }
        this.mTopShadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, SHADOWS_COLORS);
        this.mBottomShadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, SHADOWS_COLORS);
        if (bg > 0) {
            this.setBackgroundResource(bg);
        }
        this.setSoundEffectsEnabled(false);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawCenterRect(canvas);
        this.drawShadows(canvas);
    }

    @Override
    public void setOrientation(int orientation) {
        if (1 == orientation) {
            throw new IllegalArgumentException("The orientation must be VERTICAL");
        }
        super.setOrientation(orientation);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        int galleryCenter = this.getCenterOfGallery();
        View v = this.getChildAt(0);
        int height = null != v ? v.getMeasuredHeight() : 50;
        int top = galleryCenter - height / 2;
        int bottom = top + height;
        this.mSelectorBound.set(this.getPaddingLeft(), top, this.getWidth() - this.getPaddingRight(), bottom);
    }

    @Override
    protected void selectionChanged() {
        super.selectionChanged();
        this.playSoundEffect(0);
    }

    private void drawCenterRect(Canvas canvas) {
        if (null != this.mSelectorDrawable) {
            this.mSelectorDrawable.setBounds(this.mSelectorBound);
            this.mSelectorDrawable.draw(canvas);
        }
    }

    private void drawShadows(Canvas canvas) {
        int height = (int)(2.0 * (double)this.mSelectorBound.height());
        this.mTopShadow.setBounds(0, 0, this.getWidth(), height);
        this.mTopShadow.draw(canvas);
        this.mBottomShadow.setBounds(0, this.getHeight() - height, this.getWidth(), this.getHeight());
        this.mBottomShadow.draw(canvas);
    }
}

