/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.base.libs.R;
import com.basic.widgets.TosAdapterView;

public abstract class TosAbsSpinner
extends TosAdapterView<SpinnerAdapter> {
    protected SpinnerAdapter mAdapter;
    protected int mHeightMeasureSpec;
    protected int mWidthMeasureSpec;
    protected boolean mBlockLayoutRequests;
    protected int mSelectionLeftPadding = 0;
    protected int mSelectionTopPadding = 0;
    protected int mSelectionRightPadding = 0;
    protected int mSelectionBottomPadding = 0;
    protected Rect mSpinnerPadding = new Rect();
    protected View mSelectedView = null;
    protected Interpolator mInterpolator;
    protected RecycleBin mRecycler = new RecycleBin();
    private DataSetObserver mDataSetObserver;
    private Rect mTouchFrame;

    protected DataSetObserver getDataSetObserver() {
        return this.mDataSetObserver;
    }

    public TosAbsSpinner(Context context) {
        super(context);
        this.initAbsSpinner();
    }

    public TosAbsSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TosAbsSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAbsSpinner();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AbsSpinner, defStyle, 0);
        Object[] entries = a.getTextArray(R.styleable.AbsSpinner_entries);
        if (entries != null) {
            ArrayAdapter adapter = new ArrayAdapter(context, 17367048, entries);
            adapter.setDropDownViewResource(0x1090009);
            this.setAdapter((SpinnerAdapter)adapter);
        }
        a.recycle();
    }

    private void initAbsSpinner() {
        this.setFocusable(true);
        this.setWillNotDraw(false);
    }

    @Override
    public void setAdapter(SpinnerAdapter adapter) {
        if (null != this.mAdapter) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.resetList();
        }
        this.mAdapter = adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new TosAdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            int position = this.mItemCount > 0 ? 0 : -1;
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.checkFocus();
            this.resetList();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    void resetList() {
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.removeAllViewsInLayout();
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        this.mSpinnerPadding.left = this.getPaddingLeft() > this.mSelectionLeftPadding ? this.getPaddingLeft() : this.mSelectionLeftPadding;
        this.mSpinnerPadding.top = this.getPaddingTop() > this.mSelectionTopPadding ? this.getPaddingTop() : this.mSelectionTopPadding;
        this.mSpinnerPadding.right = this.getPaddingRight() > this.mSelectionRightPadding ? this.getPaddingRight() : this.mSelectionRightPadding;
        int n = this.mSpinnerPadding.bottom = this.getPaddingBottom() > this.mSelectionBottomPadding ? this.getPaddingBottom() : this.mSelectionBottomPadding;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        int preferredHeight = 0;
        int preferredWidth = 0;
        boolean needsMeasuring = true;
        int selectedPosition = this.getSelectedItemPosition();
        if (selectedPosition >= 0 && this.mAdapter != null) {
            View view = this.mRecycler.get(selectedPosition);
            if (view == null) {
                view = this.mAdapter.getView(selectedPosition, null, (ViewGroup)this);
            }
            if (view != null) {
                this.mRecycler.put(selectedPosition, view);
            }
            if (view != null) {
                if (view.getLayoutParams() == null) {
                    this.mBlockLayoutRequests = true;
                    view.setLayoutParams(this.generateDefaultLayoutParams());
                    this.mBlockLayoutRequests = false;
                }
                this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
                preferredHeight = this.getChildHeight(view) + this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
                preferredWidth = this.getChildWidth(view) + this.mSpinnerPadding.left + this.mSpinnerPadding.right;
                needsMeasuring = false;
            }
        }
        if (needsMeasuring) {
            preferredHeight = this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
            if (widthMode == 0) {
                preferredWidth = this.mSpinnerPadding.left + this.mSpinnerPadding.right;
            }
        }
        preferredHeight = Math.max(preferredHeight, this.getSuggestedMinimumHeight());
        preferredWidth = Math.max(preferredWidth, this.getSuggestedMinimumWidth());
        int heightSize = TosAbsSpinner.resolveSize((int)preferredHeight, (int)heightMeasureSpec);
        int widthSize = TosAbsSpinner.resolveSize((int)preferredWidth, (int)widthMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
        this.mHeightMeasureSpec = heightMeasureSpec;
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    int getChildHeight(View child) {
        return child.getMeasuredHeight();
    }

    int getChildWidth(View child) {
        return child.getMeasuredWidth();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    void recycleAllViews() {
        int childCount = this.getChildCount();
        RecycleBin recycleBin = this.mRecycler;
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            int index = this.mFirstPosition + i;
            recycleBin.put(index, v);
        }
    }

    @Override
    void handleDataChanged() {
        super.handleDataChanged();
    }

    public void setSelection(int position, boolean animate) {
        boolean shouldAnimate = animate && this.mFirstPosition <= position && position <= this.mFirstPosition + this.getChildCount() - 1;
        this.setSelectionInt(position, shouldAnimate);
        this.checkSelectionChanged();
    }

    @Override
    public void setSelection(int position) {
        this.setNextSelectedPositionInt(position);
        this.requestLayout();
        this.invalidate();
        this.checkSelectionChanged();
    }

    void setSelectionInt(int position, boolean animate) {
        if (position != this.mOldSelectedPosition) {
            this.mBlockLayoutRequests = true;
            int delta = position - this.mSelectedPosition;
            this.setNextSelectedPositionInt(position);
            this.layout(delta, animate);
            this.mBlockLayoutRequests = false;
        }
    }

    abstract void layout(int var1, boolean var2);

    @Override
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    public void requestLayout() {
        if (!this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    @Override
    public SpinnerAdapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public int getCount() {
        return this.mItemCount;
    }

    public int pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.selectedId = this.getSelectedItemId();
        ss.position = ss.selectedId >= 0L ? this.getSelectedItemPosition() : -1;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.selectedId >= 0L) {
            this.mDataChanged = true;
            this.mNeedSync = true;
            this.mSyncRowId = ss.selectedId;
            this.mSyncPosition = ss.position;
            this.mSyncMode = 0;
            this.requestLayout();
        }
    }

    class RecycleBin {
        private SparseArray<View> mScrapHeap = new SparseArray();

        RecycleBin() {
        }

        public void put(int position, View v) {
            this.mScrapHeap.put(position, (Object)v);
        }

        View get(int position) {
            View result = (View)this.mScrapHeap.get(position);
            if (result != null) {
                this.mScrapHeap.delete(position);
            }
            return result;
        }

        View peek(int position) {
            return (View)this.mScrapHeap.get(position);
        }

        void clear() {
            SparseArray<View> scrapHeap = this.mScrapHeap;
            int count = scrapHeap.size();
            for (int i = 0; i < count; ++i) {
                View view = (View)scrapHeap.valueAt(i);
                if (view == null) continue;
                TosAbsSpinner.this.removeDetachedView(view, true);
            }
            scrapHeap.clear();
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        long selectedId;
        int position;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.selectedId = in.readLong();
            this.position = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.selectedId);
            out.writeInt(this.position);
        }

        public String toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selectedId=" + this.selectedId + " position=" + this.position + "}";
        }
    }
}

