/*
 * Decompiled with CFR 0.152.
 */
package com.basic.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;

public class ClipView
extends View {
    private Paint paint = new Paint();
    private Paint borderPaint = new Paint();
    private int customTopBarHeight = 0;
    private double clipRatio = 1.0;
    private int clipWidth = -1;
    private int clipHeight = -1;
    private int clipLeftMargin = 0;
    private int clipTopMargin = 0;
    private int clipBorderWidth = 1;
    private boolean isSetMargin = false;
    private OnDrawListenerComplete listenerComplete;

    public ClipView(Context context) {
        super(context);
    }

    public ClipView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ClipView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        int width = metrics.widthPixels;
        int height = metrics.heightPixels;
        if (this.clipWidth == -1 || this.clipHeight == -1) {
            this.clipWidth = width - 50;
            this.clipHeight = (int)((double)this.clipWidth * this.clipRatio);
            if (width > height) {
                this.clipHeight = height - 50;
                this.clipWidth = (int)((double)this.clipHeight / this.clipRatio);
            }
        }
        if (!this.isSetMargin) {
            this.clipLeftMargin = (width - this.clipWidth) / 2;
            this.clipTopMargin = (height - this.clipHeight) / 2;
        }
        this.paint.setAlpha(200);
        canvas.drawRect(0.0f, (float)this.customTopBarHeight, (float)width, (float)this.clipTopMargin, this.paint);
        canvas.drawRect(0.0f, (float)this.clipTopMargin, (float)this.clipLeftMargin, (float)(this.clipTopMargin + this.clipHeight), this.paint);
        canvas.drawRect((float)(this.clipLeftMargin + this.clipWidth), (float)this.clipTopMargin, (float)width, (float)(this.clipTopMargin + this.clipHeight), this.paint);
        canvas.drawRect(0.0f, (float)(this.clipTopMargin + this.clipHeight), (float)width, (float)height, this.paint);
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setColor(-1);
        this.borderPaint.setStrokeWidth((float)this.clipBorderWidth);
        canvas.drawRect((float)this.clipLeftMargin, (float)this.clipTopMargin, (float)(this.clipLeftMargin + this.clipWidth), (float)(this.clipTopMargin + this.clipHeight), this.borderPaint);
        if (this.listenerComplete != null) {
            this.listenerComplete.onDrawCompelete();
        }
    }

    public int getCustomTopBarHeight() {
        return this.customTopBarHeight;
    }

    public void setCustomTopBarHeight(int customTopBarHeight) {
        this.customTopBarHeight = customTopBarHeight;
    }

    public double getClipRatio() {
        return this.clipRatio;
    }

    public void setClipRatio(double clipRatio) {
        this.clipRatio = clipRatio;
    }

    public int getClipWidth() {
        return this.clipWidth - this.clipBorderWidth;
    }

    public void setClipWidth(int clipWidth) {
        this.clipWidth = clipWidth;
    }

    public int getClipHeight() {
        return this.clipHeight - this.clipBorderWidth;
    }

    public void setClipHeight(int clipHeight) {
        this.clipHeight = clipHeight;
    }

    public int getClipLeftMargin() {
        return this.clipLeftMargin + this.clipBorderWidth;
    }

    public void setClipLeftMargin(int clipLeftMargin) {
        this.clipLeftMargin = clipLeftMargin;
        this.isSetMargin = true;
    }

    public int getClipTopMargin() {
        return this.clipTopMargin + this.clipBorderWidth;
    }

    public void setClipTopMargin(int clipTopMargin) {
        this.clipTopMargin = clipTopMargin;
        this.isSetMargin = true;
    }

    public void addOnDrawCompleteListener(OnDrawListenerComplete listener) {
        this.listenerComplete = listener;
    }

    public void removeOnDrawCompleteListener() {
        this.listenerComplete = null;
    }

    public static interface OnDrawListenerComplete {
        public void onDrawCompelete();
    }
}

