/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class TypeFaceUtil {
    private static final String PATH_TYPEFACE_REGULAR = "fonts/Bariol_Regular.otf";
    private static Typeface regularTypeface;
    private static final String PATH_TYPEFACE_LIGHT = "fonts/Bariol_Light.otf";
    private Typeface lightTypeface;
    private static final String PATH_TYPEFACE_BOLD = "fonts/Bariol_Bold.otf";
    private Typeface boldTypeface;
    private static final String PATH_TYPEFACE_BONGMI = "fonts/Bongmi.ttf";
    private Typeface bongmiTypeface;

    public Typeface getRegularTypeface(Context context) {
        if (regularTypeface == null) {
            regularTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)PATH_TYPEFACE_REGULAR);
        }
        return regularTypeface;
    }

    public Typeface getLightTypeface(Context context) {
        if (this.lightTypeface == null) {
            this.lightTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)PATH_TYPEFACE_LIGHT);
        }
        return this.lightTypeface;
    }

    public Typeface getBoldTypeface(Context context) {
        if (this.boldTypeface == null) {
            this.boldTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)PATH_TYPEFACE_BOLD);
        }
        return this.boldTypeface;
    }

    public Typeface getBongmiTypeface(Context context) {
        if (this.bongmiTypeface == null) {
            this.bongmiTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)PATH_TYPEFACE_BONGMI);
        }
        return this.bongmiTypeface;
    }

    public void setTypeFace(Typeface typeFace, ViewGroup parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View v = parent.getChildAt(i);
            if (v instanceof ViewGroup) {
                this.setTypeFace(typeFace, (ViewGroup)v);
                continue;
            }
            if (!(v instanceof TextView)) continue;
            TextView tv = (TextView)v;
            tv.setTypeface(typeFace);
            tv.setPaintFlags(tv.getPaintFlags() | 0x80);
        }
    }
}

