/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import com.basic.util.CommonUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static long createDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day);
        return c.getTimeInMillis();
    }

    public static int daysBetween(long date1, long date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date1);
        long time1 = TimeUtil.getDateBeginTimeInMillis(cal.getTimeInMillis());
        cal.setTimeInMillis(date2);
        long time2 = TimeUtil.getDateBeginTimeInMillis(cal.getTimeInMillis());
        long between_days = Math.round((double)(time2 - time1) * 1.0 / 8.64E7);
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static long getDateBeginTimeInMillis(long timeInMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMillis);
        Calendar ret = Calendar.getInstance();
        ret.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        return ret.getTimeInMillis() / 1000L * 1000L;
    }

    public static boolean isDateBeginTimeInMillis(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }

    public static int getTimestamp(long timeInMillis) {
        return Long.valueOf(timeInMillis / 1000L).intValue();
    }

    public static long getTimeInMillis(int timestamp) {
        return (long)timestamp * 1000L;
    }

    public static String getTimestampShow(long timeInMillis, boolean yearFlag, boolean secondFlag) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String monthDay = CommonUtil.isChinese() ? TimeUtil.getZero(month) + "/" + TimeUtil.getZero(day) : TimeUtil.showMonthDayFormatShort(calendar.getTime(), Locale.ENGLISH);
        String ret = monthDay + " " + TimeUtil.getZero(calendar.get(11)) + ":" + TimeUtil.getZero(calendar.get(12));
        if (yearFlag) {
            ret = year + " " + ret;
        }
        if (secondFlag) {
            ret = ret + ":" + TimeUtil.getZero(calendar.get(13));
        }
        return ret;
    }

    public static String getZero(int i) {
        String str = i + "";
        if (i < 10) {
            str = "0" + i;
        }
        return str;
    }

    public static String getTimeInMillisShow(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return calendar.get(1) + "\u5e74" + (calendar.get(2) + 1) + "\u6708" + calendar.get(5) + "\u65e5" + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13) + " " + calendar.get(14);
    }

    public static String getDateShow(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return calendar.get(1) + "\u5e74" + (calendar.get(2) + 1) + "\u6708" + calendar.get(5) + "\u65e5";
    }

    public static String getDateShowEn(long timeInMillis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        return calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
    }

    public static String getDateShowYearMonthDay(Calendar c) {
        if (CommonUtil.isChinese()) {
            return TimeUtil.getDateShow(c.getTime().getTime());
        }
        String date = c.get(5) + "th " + TimeUtil.getMonthTextAbbriviation(c) + " " + c.get(1);
        return date;
    }

    public static String getTimeShowHourMinSec(int timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
        String hourText = "";
        String minText = "";
        String secText = "";
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        hourText = hour + "";
        minText = min + "";
        secText = sec + "";
        if (hour < 10) {
            hourText = "0" + hourText;
        }
        if (min < 10) {
            minText = "0" + minText;
        }
        if (sec < 10) {
            secText = "0" + secText;
        }
        return hourText + ":" + minText + ":" + secText;
    }

    public static String getTimeShowHourMin(int timestamp) {
        if (timestamp == 0) {
            return "00:00";
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
        String hourText = "";
        String minText = "";
        int hour = calendar.get(11);
        int min = calendar.get(12);
        hourText = hour + "";
        minText = min + "";
        if (hour < 10) {
            hourText = "0" + hourText;
        }
        if (min < 10) {
            minText = "0" + minText;
        }
        return hourText + ":" + minText;
    }

    public static String getDateShowYearMonth(int timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
        if (CommonUtil.isChinese()) {
            return calendar.get(1) + "\u5e74" + (calendar.get(2) + 1) + "\u6708";
        }
        return TimeUtil.getMonthTextAbbriviation(calendar) + " " + calendar.get(1);
    }

    public static String getDateShowYearMonthDay(int timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
        if (CommonUtil.isChinese()) {
            return calendar.get(1) + "\u5e74" + (calendar.get(2) + 1) + "\u6708" + calendar.get(5) + "\u65e5";
        }
        return calendar.get(5) + "th " + TimeUtil.getMonthTextAbbriviation(calendar) + " " + calendar.get(1);
    }

    public static String getDateShowMonthDay(int timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
        if (CommonUtil.isChinese()) {
            return calendar.get(2) + 1 + "\u6708" + calendar.get(5) + "\u65e5";
        }
        String monthText = TimeUtil.getMonthTextAbbriviation(calendar);
        return calendar.get(5) + "th" + " " + monthText;
    }

    public static String getMonthTextAbbriviation(Calendar c) {
        String monthText = "";
        switch (c.get(2)) {
            case 0: {
                monthText = "Jan";
                break;
            }
            case 1: {
                monthText = "Feb";
                break;
            }
            case 2: {
                monthText = "Mar";
                break;
            }
            case 3: {
                monthText = "Apr";
                break;
            }
            case 4: {
                monthText = "May";
                break;
            }
            case 5: {
                monthText = "Jun";
                break;
            }
            case 6: {
                monthText = "Jul";
                break;
            }
            case 7: {
                monthText = "Aug";
                break;
            }
            case 8: {
                monthText = "Sept";
                break;
            }
            case 9: {
                monthText = "Oct";
                break;
            }
            case 10: {
                monthText = "Nov";
                break;
            }
            case 11: {
                monthText = "Dec";
            }
        }
        return monthText;
    }

    public static String getDateShowMonthDayNoTemperature(int timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(TimeUtil.getTimeInMillis(timestamp));
        if (CommonUtil.isChinese()) {
            return calendar.get(2) + 1 + "\u6708" + calendar.get(5) + "\u65e5";
        }
        String monthText = "";
        switch (calendar.get(2)) {
            case 0: {
                monthText = "Jan";
                break;
            }
            case 1: {
                monthText = "Feb";
                break;
            }
            case 2: {
                monthText = "Mar";
                break;
            }
            case 3: {
                monthText = "Apr";
                break;
            }
            case 4: {
                monthText = "May";
                break;
            }
            case 5: {
                monthText = "Jun";
                break;
            }
            case 6: {
                monthText = "Jul";
                break;
            }
            case 7: {
                monthText = "Aug";
                break;
            }
            case 8: {
                monthText = "Sept";
                break;
            }
            case 9: {
                monthText = "Oct";
                break;
            }
            case 10: {
                monthText = "Nov";
                break;
            }
            case 11: {
                monthText = "Dec";
            }
        }
        return calendar.get(5) + "th " + monthText;
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        long t = TimeUtil.getDateBeginTimeInMillis(c.getTimeInMillis());
        c.setTimeInMillis(t);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        long t = TimeUtil.getDateBeginTimeInMillis(c.getTimeInMillis());
        c.setTimeInMillis(t);
        return c.getTime();
    }

    public static String showMonthYearFormat(Date date, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat("MMMM yyyy", locale);
        return df.format(date);
    }

    public static String showMonthYearFormatShort(Date date, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat("MMM yyyy", locale);
        return df.format(date);
    }

    public static String showDayMonthYearFormat(Date date, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat("dd MMMM yyyy", locale);
        return df.format(date);
    }

    public static String showMonthDayFormatShort(Date date, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat("MMM dd", locale);
        return df.format(date);
    }

    public static String showHourMinuteFormatShort(Date date, Locale locale) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss", locale);
        return df.format(date);
    }

    public static String getTimeZoneIdFromGMT(TimeZone timeZone) {
        return timeZone.getID();
    }

    public static String showMinuteFormatShort(int timestamp, Locale locale) {
        Date date = new Date(TimeUtil.getTimeInMillis(timestamp));
        SimpleDateFormat df = new SimpleDateFormat("HH:mm", locale);
        return df.format(date);
    }
}

