/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.graphics.Rect;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewTreeObserver;

public class LayoutUtil {
    public static void expandTouchArea(final View ancestorView, final View childView, final Rect padding) {
        ancestorView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                TouchDelegate delegate = null;
                if (childView.isShown()) {
                    Rect hitRect = new Rect();
                    childView.getHitRect(hitRect);
                    int[] ancestorLoc = new int[2];
                    ancestorView.getLocationInWindow(ancestorLoc);
                    int[] parentLoc = new int[2];
                    ((View)childView.getParent()).getLocationInWindow(parentLoc);
                    int xOffset = parentLoc[0] - ancestorLoc[0];
                    hitRect.left += xOffset;
                    hitRect.right += xOffset;
                    int yOffset = parentLoc[1] - ancestorLoc[1];
                    hitRect.top += yOffset;
                    hitRect.bottom += yOffset;
                    hitRect.top -= padding.top;
                    hitRect.bottom += padding.bottom;
                    hitRect.left -= padding.left;
                    hitRect.right += padding.right;
                    delegate = new TouchDelegate(hitRect, childView);
                }
                ancestorView.setTouchDelegate(delegate);
            }
        });
    }
}

