/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.util.Base64;
import com.basic.util.SpecificClassExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonUtil {
    private static Gson gson;
    private static final GsonBuilder gsonBuilder;
    public static final Gson customGson;

    public static Gson getGson() {
        if (gson == null) {
            gsonBuilder.excludeFieldsWithModifiers(new int[]{16, 128, 8});
            try {
                Class<?> clazz = Class.forName("com.activeandroid.Model");
                gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new SpecificClassExclusionStrategy(null, clazz)});
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            gson = gsonBuilder.create();
        }
        return gson;
    }

    static {
        gsonBuilder = new GsonBuilder();
        customGson = new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).create();
    }

    private static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        private ByteArrayToBase64TypeAdapter() {
        }

        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.decode((String)json.getAsString(), (int)2);
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.encodeToString((byte[])src, (int)2));
        }
    }
}

