/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.inputmethod.InputMethodManager;
import cn.lollypop.be.model.Language;
import com.orhanobut.logger.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtil {
    private static long lastClickTime;

    public static boolean isEmail(String email) {
        boolean flag;
        try {
            String check = "^\\s*\\w+(?:\\.?[\\w-]+)*@[a-zA-Z0-9]+(?:[-.][a-zA-Z0-9]+)*\\.[a-zA-Z]+\\s*$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            flag = matcher.matches();
        }
        catch (Exception e) {
            Logger.i((String)"\u9a8c\u8bc1\u90ae\u7bb1\u5730\u5740\u9519\u8bef", (Object[])new Object[0]);
            flag = false;
        }
        return flag;
    }

    public static boolean isNumber(String number) {
        Pattern p = Pattern.compile("^[0-9]{1,}$");
        Matcher m = p.matcher(number);
        return m.matches();
    }

    public static boolean isMobilePhoneNum(String telNum) {
        String regex = "^((1[0-9]))\\d{9}$";
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(telNum);
        return m.matches();
    }

    public static boolean isPassword(String words) {
        Pattern p = Pattern.compile("(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*?.]+)$)^[\\w~!@#$%\\^&*?.]{8,18}+$");
        Matcher m = p.matcher(words);
        return m.matches();
    }

    public static boolean isFastDoubleClick() {
        long time = System.currentTimeMillis();
        long timeD = time - lastClickTime;
        if (0L < timeD && timeD < 300L) {
            Log.d((String)"TimeUtils", (String)("\u76f8\u9694\uff1a" + timeD));
            return true;
        }
        lastClickTime = time;
        Log.d((String)"TimeUtils", (String)("\u4e0a\u6b21\u70b9\u51fb\u4e8b\u4ef6\uff1a" + lastClickTime));
        return false;
    }

    public static boolean isFastDoubleClick(long dis) {
        long time = System.currentTimeMillis();
        long timeD = time - lastClickTime;
        if (0L < timeD && timeD < dis) {
            return true;
        }
        lastClickTime = time;
        Log.d((String)"TimeUtils", (String)("\u4e0a\u6b21\u70b9\u51fb\u4e8b\u4ef6\uff1a" + lastClickTime));
        return false;
    }

    public static boolean hideInputMethod(Activity activity) {
        if (activity == null) {
            return false;
        }
        InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (activity.getCurrentFocus() != null) {
            imm.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
            return true;
        }
        return false;
    }

    public static float pixelToDp(Context context, float val) {
        float density = context.getResources().getDisplayMetrics().density;
        return val * density;
    }

    public static String getHashedFileName(String url) {
        if (url == null || url.endsWith("/")) {
            return null;
        }
        String suffix = CommonUtil.getSuffix(url);
        StringBuilder sb = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] dstbytes = digest.digest(url.getBytes("UTF-8"));
            sb = new StringBuilder();
            for (int i = 0; i < dstbytes.length; ++i) {
                sb.append(Integer.toHexString(dstbytes[i] & 0xFF));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != sb && null != suffix) {
            return sb.toString() + "." + suffix;
        }
        return null;
    }

    private static String getSuffix(String fileName) {
        int sl_point;
        int dot_point = fileName.lastIndexOf(".");
        if (dot_point < (sl_point = fileName.lastIndexOf("/"))) {
            return "";
        }
        if (dot_point != -1) {
            return fileName.substring(dot_point + 1);
        }
        return null;
    }

    public static void gotoScore(Context context) throws ActivityNotFoundException {
        Uri uri = Uri.parse((String)("market://details?id=" + context.getPackageName()));
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static boolean isChinese() {
        String language = Locale.getDefault().getLanguage();
        String country = Locale.getDefault().getCountry();
        return language.equals(Locale.SIMPLIFIED_CHINESE.getLanguage()) && country.equals(Locale.SIMPLIFIED_CHINESE.getCountry());
    }

    public static void shareMsg(Context context, String msgTitle, String msgText) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("sms_body", msgText);
        intent.putExtra("android.intent.extra.SUBJECT", msgTitle);
        intent.putExtra("android.intent.extra.TEXT", msgText);
        intent.setFlags(0x10000000);
        context.startActivity(Intent.createChooser((Intent)intent, (CharSequence)msgTitle));
    }

    public static void shareImg(Context context, String imgPath) {
        File f;
        Intent intent = new Intent("android.intent.action.SEND");
        if (!TextUtils.isEmpty((CharSequence)imgPath) && (f = new File(imgPath)).exists() && f.isFile()) {
            intent.setType("image/jpg");
            Uri u = Uri.fromFile((File)f);
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)u);
        }
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static int randomInt(int len) {
        Random random = new Random();
        int min = Double.valueOf(Math.pow(10.0, len - 1)).intValue();
        int max = Double.valueOf(Math.pow(10.0, len)).intValue();
        return min + random.nextInt(max);
    }

    public static byte[] convertInputStreamToByteArray(InputStream inputStream) {
        byte[] bytes = null;
        try {
            int count;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((count = inputStream.read(data)) != -1) {
                bos.write(data, 0, count);
            }
            bos.flush();
            bos.close();
            inputStream.close();
            bytes = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static float convertFloat(float f) {
        DecimalFormat df = new DecimalFormat("#.##");
        try {
            return df.parse(df.format(f)).floatValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return f;
        }
    }

    public static int floatToInt(float f, int scale) {
        return (int)Math.round(Math.pow(10.0, scale) * (double)f);
    }

    public static float convertDoubleToFloat(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        try {
            return df.parse(df.format(d)).floatValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return Double.valueOf(d).floatValue();
        }
    }

    public static int convertFloatToInt(float f, int multiple) {
        Double d = Double.valueOf(String.valueOf(f)) * (double)multiple;
        return (int)Math.round(d);
    }

    public static String convert10ToString(int ten) {
        if (ten < 10 && ten >= 0) {
            return "0" + ten;
        }
        return String.valueOf(ten);
    }

    public static String convertTemperature(float temperature) {
        DecimalFormat mFormat = new DecimalFormat("0.00");
        return mFormat.format(temperature);
    }

    public static String convertRate(float rate) {
        DecimalFormat mFormat = new DecimalFormat("0.0");
        return mFormat.format(rate);
    }

    public static Drawable getDrawable(Context context, int id2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(id2, context.getTheme());
        }
        return context.getResources().getDrawable(id2);
    }

    public static int getColor(Context context, int id2) {
        return context.getResources().getColor(id2);
    }

    public static String getProvidersName(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getSimOperatorName();
    }

    public static int getIntegerFromDouble(double num) {
        return (int)num;
    }

    public static int getDecimalFromDouble(double num) {
        return (int)((num - (double)CommonUtil.getIntegerFromDouble(num) + 0.01) * 10.0);
    }

    public static double getDoubleFromDecimal(int integer, int decimal) {
        return ((double)decimal + 0.0) / 10.0 + (double)integer;
    }

    public static int convertToRealBalance(int number) {
        return (int)Math.round((double)number / 100.0);
    }

    public static int convertToServerBalance(double number) {
        return (int)Math.round(number * 100.0);
    }

    public static String encriptAccountDisplay(String number, AccountType accountType) {
        String starString = "****";
        StringBuilder stringBuffer = new StringBuilder();
        if (accountType.getValue() == AccountType.ALIPAY_ACCOUNT.getValue()) {
            accountType = number.contains("@") ? AccountType.EMAIL : AccountType.PHONE_NUMBER;
        }
        switch (accountType) {
            case USER_NAME: 
            case PHONE_NUMBER: {
                if (number.length() < 7) {
                    for (int i = 0; i < 3 && i < number.length(); ++i) {
                        stringBuffer.append(number.charAt(i));
                    }
                    stringBuffer.append(starString);
                    break;
                }
                stringBuffer.append(number.substring(0, 3)).append(starString).append(number.substring(7, number.length()));
                break;
            }
            case EMAIL: {
                int divisionPosition = number.indexOf("@");
                for (int i = 0; i < 3 && i < divisionPosition; ++i) {
                    stringBuffer.append(number.charAt(i));
                }
                stringBuffer.append(starString);
                stringBuffer.append(number.substring(divisionPosition, number.length()));
                break;
            }
        }
        return stringBuffer.toString();
    }

    public static int getLanguage() {
        return CommonUtil.isChinese() ? Language.CHINESE.getLanguage() : Language.ENGLISH.getLanguage();
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static <T> List<T> reverseList(List<T> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int size = list.size();
        LinkedList<T> reverseList = new LinkedList<T>();
        for (int i = size - 1; i >= 0; --i) {
            reverseList.add(list.get(i));
        }
        return reverseList;
    }

    public static float scaleValue(double value, int scale) {
        String scales = "#.";
        for (int i = 1; i <= scale; ++i) {
            scales = scales + "#";
        }
        DecimalFormat df = new DecimalFormat(scales);
        try {
            return df.parse(df.format(value)).floatValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static enum AccountType {
        EMAIL(1),
        PHONE_NUMBER(2),
        USER_NAME(3),
        ALIPAY_ACCOUNT(4);

        private final int value;

        private AccountType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

