/*
 * Decompiled with CFR 0.152.
 */
package com.basic.util;

import android.animation.ValueAnimator;
import android.view.View;

public class AnimationUtil {
    public static void moveVertical(View view, float start, float end, int duration, AnimationCallback animationCallback) {
        AnimationUtil.move(view, start, end, duration, 1, animationCallback);
    }

    public static void moveHorizontal(View view, float start, float end, int duration, AnimationCallback animationCallback) {
        AnimationUtil.move(view, start, end, duration, 2, animationCallback);
    }

    private static void move(final View view, float start, final float end, int duration, final int direct, final AnimationCallback animationCallback) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{start, end});
        valueAnimator.setDuration((long)duration);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float current = ((Float)animation.getAnimatedValue()).floatValue();
                if (direct == 1) {
                    view.setY(current);
                } else {
                    view.setX(current);
                }
                if (current == end) {
                    animationCallback.animationEnd();
                }
            }
        });
        valueAnimator.start();
    }

    public static interface AnimationCallback {
        public void animationEnd();
    }
}

