/*
 * Decompiled with CFR 0.152.
 */
package com.basic.controller;

import android.os.Handler;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RefreshManager {
    private static RefreshManager ourInstance = new RefreshManager();
    private final Map<Integer, RefreshCallback> refreshCallbackMap = new HashMap<Integer, RefreshCallback>();
    private static final List<Integer> currentCodes = new ArrayList<Integer>();
    private static final Object refreshLock = new Object();
    private final Handler mainThreadHandler = new Handler();
    private final Runnable runnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RefreshManager.this.mainThreadHandler.removeCallbacks((Runnable)this);
            List list = currentCodes;
            synchronized (list) {
                while (currentCodes.size() > 0) {
                    int code = (Integer)currentCodes.remove(0);
                    Log.d((String)"BaseApplication", (String)("refresh view code : " + code));
                    RefreshCallback refreshCallback = (RefreshCallback)RefreshManager.this.refreshCallbackMap.get(code);
                    if (refreshCallback == null) continue;
                    refreshCallback.doCallback(code);
                }
            }
        }
    };

    public static RefreshManager getInstance() {
        return ourInstance;
    }

    private RefreshManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRefreshCallback(int code, RefreshCallback refreshCallback) {
        Object object = refreshLock;
        synchronized (object) {
            this.refreshCallbackMap.put(code, refreshCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterRefreshCallback(int code) {
        Object object = refreshLock;
        synchronized (object) {
            if (this.refreshCallbackMap.containsKey(code)) {
                this.refreshCallbackMap.remove(code);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshView(int code) {
        List<Integer> list = currentCodes;
        synchronized (list) {
            Log.d((String)"BaseApplication", (String)("add refresh view code : " + code));
            currentCodes.add(code);
            this.mainThreadHandler.post(this.runnable);
        }
    }

    public static interface RefreshCallback {
        public void doCallback(int var1);
    }
}

