/*
 * Decompiled with CFR 0.152.
 */
package com.basic.controller;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.basic.activity.BaseActivity;
import com.basic.util.TimeUtil;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;

public class PermissionRequestManager {
    public static final int REQUEST_PERMISSION_CODE = 181;
    private static final String REQUEST_PERMISSION_TIME = "REQUEST_PERMISSION_TIME";
    private static PermissionRequestManager instance = new PermissionRequestManager();

    private PermissionRequestManager() {
    }

    public static PermissionRequestManager getInstance() {
        return instance;
    }

    public boolean requestPermissions(BaseActivity activity, int familyMemberId) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (!activity.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE")) {
            permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        }
        if (!activity.checkPermission("android.permission.ACCESS_COARSE_LOCATION")) {
            permissions.add("android.permission.ACCESS_COARSE_LOCATION");
        }
        if (!activity.checkPermission("android.permission.ACCESS_FINE_LOCATION")) {
            permissions.add("android.permission.ACCESS_FINE_LOCATION");
        }
        Logger.d((Object)("\u8bf7\u6c42\u6743\u9650\u6570\u91cf \uff1a " + permissions.size()));
        if (permissions.size() > 0) {
            if (Build.VERSION.SDK_INT >= 23) {
                activity.requestPermissions(permissions.toArray(new String[permissions.size()]), 181);
            }
            int currentTime = TimeUtil.getTimestamp(TimeUtil.getDateBeginTimeInMillis(System.currentTimeMillis()));
            this.setRequestPermissionTime((Context)activity, currentTime, familyMemberId);
            return true;
        }
        return false;
    }

    public boolean checkShowRequest(Context context, int familyMemberId) {
        int lastRequestTime = this.getRequestPermissionTime(context, familyMemberId);
        int currentTime = TimeUtil.getTimestamp(TimeUtil.getDateBeginTimeInMillis(System.currentTimeMillis()));
        return currentTime != lastRequestTime;
    }

    private void setRequestPermissionTime(Context context, int timestamp, int familyMemberId) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(REQUEST_PERMISSION_TIME + familyMemberId, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(REQUEST_PERMISSION_TIME, timestamp);
        editor.apply();
    }

    private int getRequestPermissionTime(Context context, int familyMemberId) {
        SharedPreferences settings = context.getSharedPreferences(REQUEST_PERMISSION_TIME + familyMemberId, 0);
        return settings.getInt(REQUEST_PERMISSION_TIME, 0);
    }
}

