/*
 * Decompiled with CFR 0.152.
 */
package cn.lollypop.be.model.bodystatus;

import cn.lollypop.be.model.bodystatus.BodyStatusDetail;

public class MedicationInfo
extends BodyStatusDetail {
    private int medicines = 0;
    private String custom;

    public int getMedicines() {
        return this.medicines;
    }

    public void setMedicine(int medicine) {
        this.medicines |= medicine;
    }

    public String getCustom() {
        return this.custom;
    }

    public void setCustom(String custom) {
        this.custom = custom;
        this.medicines = custom != null ? (this.medicines |= MedicineType.CUSTOM.getValue()) : (this.medicines &= ~MedicineType.CUSTOM.getValue());
    }

    public boolean hasCustom() {
        return (this.medicines & MedicineType.CUSTOM.getValue()) != 0 && this.custom != null;
    }

    public String toString() {
        return "MedicationInfo{medicines=" + this.medicines + (this.hasCustom() ? ", custom=" + this.custom : "") + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MedicineType {
        UNKNOWN(0),
        CONTRACEPTIVE(1),
        COLD(2),
        PAINKILLER(4),
        ANTI_INFLAMMATION(8),
        GASTROENTERITIS(16),
        OTHER(32),
        TRADITIONAL_CHINESE_MEDICINE(64),
        CUSTOM(128);

        private final int value;

        private MedicineType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

